import '../../../../../common/constant/apis.dart';
import '../../../../../core/network/http.dart';
import '../../../../../features/lms/data/model/lmsCompletedResponse.dart';
import '../../../../../features/lms/data/model/lmsResponse.dart';
import '../../../../../features/lms/data/model/lmsSubject.dart';



class LmsService {

  Future<List<LmsSubjectResponse>> getSubjects(String regsId) async {
    Request request = Request(
      EndPoints.getLmsQuiz,
      RequestMethod.get,
      authorized: true,
        queryParams: {
          'registration_record_id': regsId,
        }
    );
    Map<String, dynamic> response = await request.sendRequest();

    return LmsSubjectResponse.fromJsonList(response, 'data');
  }


  Future<List<LmsResponse>> getQuiz(String subjectId,String regsId) async{
    Request request = Request(
      EndPoints.getLmsQuiz,
      RequestMethod.get,
      authorized: true,
        queryParams: {
          'subject_id' : subjectId,
          'registration_record_id' : regsId,
          'paginated' : 'false'
        }
    );
    Map<String, dynamic> response = await request.sendRequest();
    print(response);
    return LmsResponse.fromJsonList(response, 'data');
  }

  Future<List<LmsCompletedResponse>> getQuizCompleted(String subjectId, String regsId) async {
    Request request = Request(
      EndPoints.getQuizCompleted,
      RequestMethod.get,
      authorized: true,
        queryParams: {
          'subject_id' : subjectId,
          'registration_record_id' : regsId,
          'paginated' : 'false'
        }
    );
    Map<String, dynamic> response = await request.sendRequest();
    print(response);
    return LmsCompletedResponse.fromJsonList(response, 'data');
  }



}
