import 'dart:async';

import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:quickalert/quickalert.dart';
import '../../../../../common/constant/colors.dart';
import '../../../../../common/constant/font.dart';
import '../../../../../common/extensions/widget.dart';
import '../../../../../common/widgets/text.dart';
import '../../../../../core/routing/routing_manager.dart';
import '../../../../../features/lms/business_logic/quizController.dart';
import '../../../../../features/lms/data/model/quizModel.dart';
import 'package:timer_count_down/timer_controller.dart';
import 'package:timer_count_down/timer_count_down.dart';

class StartQuiz extends StatefulWidget {
  const StartQuiz({super.key});

  @override
  State<StartQuiz> createState() => _StartQuizState();
}

class _StartQuizState extends State<StartQuiz> {

  QuizController quizController = Get.put(QuizController());

  CountdownController questionController = CountdownController();
  CountdownController quizTimeController = CountdownController();

  final textFieldController = TextEditingController();

  QuizModel quizModel = QuizModel.zero();
  String? quizId;

  var currentQuestionIndex;

  int correctAnswer = 0;
  int wrongAnswer = 0;
  int isCorrect = 0;
  var maxSecond;

  var tempId;
  int correctIndex = 100;
  int counterValue = 0;

  bool isStart = false;
  bool isComment = false;
  bool hasAnswer = false;

  bool isLoading = false;

  late Timer? _timer;

  List<String> nice = ['A', 'B', 'C', 'D', 'F'];

  Map<String, dynamic> test1 = <String, dynamic>{};
  Map<String, dynamic> test2 = <String, dynamic>{};
  Map<String, dynamic> test3 = <String, dynamic>{};
  Map<String, dynamic> test4 = <String, dynamic>{};
  Map<String, dynamic> test5 = <String, dynamic>{};

  Map<String, dynamic> test = <String, dynamic>{};

  List<Map<String, dynamic>> data = [];



  @override
  void initState() {
    super.initState();
    quizId = Get.arguments[0];
    quizModel = Get.arguments[1];
    currentQuestionIndex = 0;
    _timer = Timer.periodic(Duration(seconds: 1), (Timer timer) {
      setState(() {
        counterValue++;
      });
    });
  }

  @override
  void dispose() {
    if (_timer != null) {
      _timer!.cancel();
      _timer = null;
    }
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    maxSecond = quizModel.time;
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          leading: IconButton(
              onPressed: () {
                quizTimeController.pause();
                RoutingManager.to(
                  'lmsPage',
                );
                // Get.back();
              },
              icon: Icon(
                Icons.arrow_back,
                size: 35,
                color: AppColors.newPrimeColor,
              )),
          actions: [
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 8.0),
              child: HeadTitleText(
                "Question",
                size: 15,
                color: AppColors.newPrimeColor,
              ),
            ),
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 0.0),
              child: HeadTitleText(
                "${currentQuestionIndex + 1}", //"15",
                size: 20,
                color: Colors.black,
              ),
            ),
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 0.0),
              child: HeadTitleText(
                "/ ${quizModel.questionNumber.toString()}",
                size: 15,
                color: AppColors.newPrimeColor,
              ),
            ),
            SizedBox(
              width: Get.width * 0.03,
            )
          ],
        ),
        body: SingleChildScrollView(
          child: SizedBox(
            height: Get.height * 0.907,
            child: Stack(
              children: [
                // correct and wrong answer number
                Padding(
                  padding: EdgeInsets.only(
                      left: Get.width * 0.07,
                      top: Get.height * 0.03,
                      right: Get.width * 0.07),
                  child: SizedBox(
                    width: MediaQuery.of(context).size.width * 0.9,
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Row(
                          children: [
                            HeadTitleText(
                              correctAnswer.toString(),
                              color: AppColors.correctAnswer,
                            ),
                            SizedBox(
                              width: Get.width * 0.015,
                            ),
                            CircleAvatar(
                              backgroundColor: AppColors.correctAnswer,
                              radius: 8,
                            )
                          ],
                        ),
                        Row(
                          children: [
                            HeadTitleText(
                              wrongAnswer.toString(),
                              color: AppColors.wrongAnswer,
                            ),
                            SizedBox(
                              width: Get.width * 0.015,
                            ),
                            CircleAvatar(
                              backgroundColor: AppColors.wrongAnswer,
                              radius: 8,
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                ),
                Column(
                  children: [
                    Padding(
                      padding: EdgeInsets.only(
                          top: Get.height * 0.06,
                          bottom: Get.height * 0.01,
                          left: Get.width * 0.05,
                          right: Get.width * 0.05),
                      child: Container(
                        width: MediaQuery.of(context).size.width * 0.9,
                        height: MediaQuery.of(context).size.height * 0.25,
                        decoration: BoxDecoration(
                            gradient: const LinearGradient(
                                colors: [
                                  Color.fromRGBO(
                                      232, 211, 211, 1), //rgba(232, 211, 211, 1)
                                  Color.fromRGBO(
                                      217, 217, 217, 1), //rgba(217, 217, 217, 1)
                                ]),
                            borderRadius: BorderRadius.circular(20)),
                        child: Padding(
                          padding: EdgeInsets.symmetric(
                              horizontal: Get.width * 0.04,
                              vertical: Get.height * 0.035),
                          child: isStart == true ? HeadTitleText(
                            quizModel.questions[currentQuestionIndex].name,
                          ) : Text(''),
                        ),
                      ),
                    ),
                    SizedBox(
                      height: MediaQuery.of(context).size.height / 2,
                      width: MediaQuery.of(context).size.width,
                      // color: Colors.green,
                      child: ListView.builder(
                        itemCount: quizModel
                            .questions[currentQuestionIndex].answers.length,
                        itemBuilder: (BuildContext context, index) {
                          return Padding(
                            padding: EdgeInsets.only(
                                top: Get.height * 0.03 /*121.0*/,
                                left: Get.width * 0.05,
                                right: Get.width * 0.05),
                            child: GestureDetector(
                              onTap: () {
                                print('/**************************************/');
                                print(counterValue);
                                questionController.pause();
                                if (quizModel.questions[currentQuestionIndex]
                                        .answers[index].isCorrect ==
                                    1) {
                                  setState(() {
                                    isCorrect = 1;
                                    isComment = false;
                                    hasAnswer = true;
                                    data.add({
                                      'time': counterValue,
                                      'answer_id': quizModel
                                          .questions[currentQuestionIndex]
                                          .answers[index]
                                          .id,
                                      'comment': textFieldController.text
                                    });
                                    // counterValue = 0;
                                  });
                                } else {
                                  setState(() {
                                    isCorrect = 2;
                                    isComment = false;
                                    hasAnswer = true;
                                    data.add({
                                      'time': counterValue,
                                      'answer_id': quizModel
                                          .questions[currentQuestionIndex]
                                          .answers[index]
                                          .id,
                                      'comment': textFieldController.text
                                    });
                                    // counterValue = 0;
                                  });
                                }
                                // RoutingManager.to('quizStart');
                              },
                              child: Container(
                                decoration: BoxDecoration(
                                    color: AppColors.quizItem,
                                    borderRadius: const BorderRadius.all(
                                      Radius.circular(30),
                                    ),
                                    border: Border.all(
                                        color: isCorrect == 0
                                            ? AppColors.quizItem
                                            : quizModel
                                                        .questions[
                                                            currentQuestionIndex]
                                                        .answers[index]
                                                        .isCorrect ==
                                                    1
                                                ? AppColors.correctAnswer
                                                : AppColors.wrongAnswer)),
                                height: MediaQuery.of(context).size.height * 0.06,
                                width: MediaQuery.of(context).size.width * 0.9,
                                child: Padding(
                                  padding: const EdgeInsets.all(8.0),
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      SizedBox(
                                        width: Get.width *0.75,
                                        child: AutoSizeText(
                                          '${nice[index]}. ${quizModel.questions[currentQuestionIndex].answers[index].name} ',
                                          style: TextStyle(
                                              fontSize: 20,
                                              fontFamily: AppFonts.alatsi,
                                              fontWeight: FontWeight.normal
                                          ),
                                          maxLines: 2,
                                        ),
                                      ),
                                      // HeadTitleText(
                                      //   '${nice[index]}. ${quizModel.questions[currentQuestionIndex].answers[index].name}',
                                      //   size: 20,
                                      //   color: Colors.black,
                                      //   fontFamily: AppFonts.alatsi,
                                      // ),
                                      isCorrect == 0
                                          ? SizedBox()
                                          : quizModel
                                                      .questions[
                                                          currentQuestionIndex]
                                                      .answers[index]
                                                      .isCorrect ==
                                                  1
                                              ? Icon(
                                                  Icons
                                                      .check_circle_outline_rounded,
                                                  color: Colors.green,
                                                )
                                              : Icon(
                                                  Icons.cancel_outlined,
                                                  color: Colors.red,
                                                )
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          );
                        },
                      ),
                    ),
                  ],
                ),
                // timer countDown
                Positioned(
                  top: - 5,//Get.height * 0.00,
                  left: Get.width * 0.4,
                  right: Get.width * 0.4,
                  child: Center(
                    child: Countdown(
                      seconds: quizModel.time * 60 ,
                      controller: quizTimeController,
                      build: (BuildContext context, double quizTime) {
                        return Countdown(
                            seconds: quizModel.questions[currentQuestionIndex].time,
                            controller: questionController,
                            build: (BuildContext context, double questionTime) {
                              return Container(
                                // color: Colors.greenAccent,
                                child: Column(
                                  children: [
                                    HeadTitleText(
                                      "${(quizTime.toInt() ~/ 60)}:${(quizTime % 60).round()}",
                                      color: AppColors.newPrimeColor,
                                    ),
                                    Container(
                                      height: 68,
                                      width: 68,
                                      decoration: BoxDecoration(
                                          color: AppColors.newPrimeColor,
                                          shape: BoxShape.circle),
                                      child: Padding(
                                        padding: EdgeInsets.all(Get.width * 0.01),
                                        child: SizedBox(
                                          height: 65,
                                          width: 65,
                                          child: Stack(
                                            fit: StackFit.expand,
                                            children: [
                                              CircularProgressIndicator(
                                                // value: 0,
                                                value: questionTime == 0 ? 0 : questionTime /
                                                    quizModel
                                                        .questions[
                                                            currentQuestionIndex]
                                                        .time,
                                                color: Colors.white,
                                                strokeWidth: 2,
                                              ),
                                              Center(
                                                child: HeadTitleText(
                                                  questionTime.toInt().toString(),
                                                  size: 25,
                                                  color: Colors.white,
                                                  fontFamily: AppFonts.alatsi,
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                    )
                                  ],
                                ),
                              );
                            },
                            interval: const Duration(milliseconds: 1000),
                          // onFinished: (){
                          //     questionController.pause();
                          // },
                        );
                      },
                      interval: const Duration(seconds: 1),
                      onFinished: () {
                        print('Timer is done!');
                        print(counterValue);
                        QuickAlert.show(
                            onConfirmBtnTap: () {
                              RoutingManager.offAll('home-page');
                              // RoutingManager.to('lmsPage');
                            },
                            context: context,
                            type: QuickAlertType.error,
                            title: 'Oops...',
                            text: 'Sorry, Quiz time Over',
                            confirmBtnColor: (Colors.red[900])!);
                      },
                    ),
                  ),
                ),
                // next button
                Positioned(
                  bottom: Get.height * 0.00,
                  child: Padding(
                      padding: EdgeInsets.symmetric(horizontal: Get.width * 0.0),
                      child: SizedBox(
                        // color: Colors.yellow,
                        width: Get.width,
                        height: 120,//Get.width * 0.9,
                        child: Column(
                          mainAxisAlignment: isComment == false ? MainAxisAlignment.center : MainAxisAlignment.spaceBetween,
                          children: [
                            Padding(
                              padding: EdgeInsets.symmetric(horizontal: Get.width * 0.05),
                              child: Container(
                                child: hasAnswer == true
                                        ? currentQuestionIndex + 1 != quizModel.questionNumber
                                            ? GestureDetector(
                                    onTap:  hasAnswer == false ? null : () {
                                      print('on tap');
                                      questionController.start();
                                      quizTimeController.start();
                                      if (isCorrect != 0) {
                                        if (isCorrect == 1) {
                                          setState(() {
                                            correctAnswer++;
                                            // data.add(test);
                                            currentQuestionIndex++;
                                            textFieldController.clear();
                                            hasAnswer = false;
                                            counterValue = 0;
                                          });
                                        } else {
                                          setState(() {
                                            wrongAnswer++;
                                            currentQuestionIndex++;
                                            textFieldController.clear();
                                            hasAnswer = false;
                                            counterValue = 0;
                                          });
                                        }
                                        print('***************************************');
                                        print("detail of answer $currentQuestionIndex");
                                        print("answer after + $counterValue");
                                        print(data);
                                        print(textFieldController.text);
                                        isCorrect = 0;
                                      }
                                    },
                                    child: Container(
                                      width: MediaQuery.of(context).size.width * 0.7,
                                      height: MediaQuery.of(context).size.height * 0.05,
                                      decoration: BoxDecoration(
                                          color: AppColors.newPrimeColor,
                                          borderRadius: BorderRadius.circular(40)),
                                      child: HeadTitleText(
                                        'Next'.toUpperCase(),
                                        size: 20,
                                        color: Colors.white, //AppColors.newPrimeColor,
                                        fontFamily: AppFonts.alatsi,
                                      ).center(),
                                    ))
                                            : GestureDetector(
                                    onTap: hasAnswer == false ? null : () async {
                                      if (isCorrect != 0) {
                                        if (isCorrect == 1) {
                                          setState(() {
                                            isLoading = true;
                                            correctAnswer++;
                                            // hasAnswer = false;
                                            counterValue = 0;
                                          });
                                        } else {
                                          setState(() {
                                            isLoading = true;
                                            wrongAnswer++;
                                            // hasAnswer = false;
                                            counterValue = 0;
                                          });
                                        }
                                        quizTimeController.isCompleted;
                                        tempId = await quizController.updateQuizInfo(data: data, quizId: quizId ?? '');
                                        print('dddddddddddd');
                                        print(tempId);
                                        setState(() {
                                          isLoading = false;
                                          hasAnswer = false;
                                        });
                                        // print('***************************************');
                                        // print("detail of answer $currentQuestionIndex");
                                        // print("answer after + $counterValue");
                                        // print(data);
                                        // print('***************************************');
                                        // print("correct answer is : $correctAnswer");
                                        // print("wrong answer is : $wrongAnswer");
                                        // print(textFieldController.text);
                                      }
                                      quizTimeController.pause();

                                      await quizController.getQuizReport(tempId);
                                                RoutingManager.to(
                                          'lmsPage',
                                        );
                                      RoutingManager.to(
                                        RoutesName.lmsSummary,
                                        arguments: tempId
                                      );
                                    },
                                    child: Container(
                                      width: MediaQuery.of(context).size.width * 0.7,
                                      height: MediaQuery.of(context).size.height * 0.05,
                                      decoration: BoxDecoration(
                                          color: AppColors.newPrimeColor,
                                          borderRadius: BorderRadius.circular(40)),
                                      child: isLoading == true
                                          ? CircularProgressIndicator(
                                        color: Colors.white,
                                        backgroundColor: Colors.grey,
                                      ).center().padding(padding: EdgeInsets.symmetric(vertical: 5))
                                          : HeadTitleText(
                                        'Finish'.toUpperCase(),
                                        size: 20,
                                        color: Colors.white, //AppColors.newPrimeColor,
                                        fontFamily: AppFonts.alatsi,
                                      ).center(),
                                    )
                                )
                                        : TextField(
                                  controller: textFieldController,
                                  cursorColor: AppColors.newPrimeColor,
                                  textAlignVertical: TextAlignVertical.bottom,
                                  keyboardType: TextInputType.multiline,
                                  textInputAction: TextInputAction.newline,
                                  maxLines: 2,
                                  maxLength: 150,
                                  decoration: InputDecoration(
                                    labelText: 'Comment',
                                    labelStyle: TextStyle(
                                        color: AppColors.newPrimeColor
                                    ),
                                    enabledBorder: OutlineInputBorder(
                                        borderRadius: BorderRadius.circular(40),
                                        borderSide: const BorderSide(color: Colors.black)
                                    ),
                                    focusedBorder: OutlineInputBorder(
                                        borderRadius: BorderRadius.circular(40),
                                        borderSide: const BorderSide(color: Colors.black)
                                    ),
                                    hintText: 'Enter a search term',
                                  ),
                                )
                                // color: Colors.red,
                                // child:
                                // Row(
                                //   mainAxisAlignment: isComment == false ? MainAxisAlignment.spaceBetween : MainAxisAlignment.center,
                                //   children: [
                                //     isComment == false
                                //         ? GestureDetector(
                                //       onTap: (){
                                //         setState(() {
                                //           isComment = true;
                                //         });
                                //       },
                                //       child: Icon(CupertinoIcons.chat_bubble_text,size: 40,color: AppColors.newPrimeColor,),
                                //     )
                                //         : SizedBox(),
                                //     currentQuestionIndex + 1 != quizModel.questionNumber
                                //         ? GestureDetector(
                                //         onTap:  hasAnswer == false ? null : () {
                                //           print('on tap');
                                //           // print("current Index is + $currentQuestionIndex" );
                                //           questionController.start();
                                //           quizTimeController.start();
                                //           if (isCorrect != 0) {
                                //             if (isCorrect == 1) {
                                //               setState(() {
                                //                 correctAnswer++;
                                //                 // data.add(test);
                                //                 currentQuestionIndex++;
                                //                 textFieldController.clear();
                                //                 counterValue = 0;
                                //               });
                                //             } else {
                                //               setState(() {
                                //                 wrongAnswer++;
                                //                 currentQuestionIndex++;
                                //                 textFieldController.clear();
                                //                 counterValue = 0;
                                //               });
                                //             }
                                //             print('***************************************');
                                //             print("detail of answer $currentQuestionIndex");
                                //             print("answer after + $counterValue");
                                //             print(data);
                                //             print(textFieldController.text);
                                //             isCorrect = 0;
                                //           }
                                //         },
                                //         child: Container(
                                //           width: MediaQuery.of(context).size.width * 0.7,
                                //           height: MediaQuery.of(context).size.height * 0.05,
                                //           decoration: BoxDecoration(
                                //               color: AppColors.newPrimeColor,
                                //               borderRadius: BorderRadius.circular(40)),
                                //           child: HeadTitleText(
                                //             'Next'.toUpperCase(),
                                //             size: 20,
                                //             color: Colors.white, //AppColors.newPrimeColor,
                                //             fontFamily: AppFonts.alatsi,
                                //           ).center(),
                                //         ))
                                //         : GestureDetector(
                                //         onTap: hasAnswer == false ? null : () {
                                //           if (isCorrect != 0) {
                                //             if (isCorrect == 1) {
                                //               setState(() {
                                //                 correctAnswer++;
                                //                 counterValue = 0;
                                //               });
                                //             } else {
                                //               setState(() {
                                //                 wrongAnswer++;
                                //                 counterValue = 0;
                                //               });
                                //             }
                                //             quizController.updateQuizInfo(data: data, quizId: quizId ?? '');
                                //             print('***************************************');
                                //             print("detail of answer $currentQuestionIndex");
                                //             print("answer after + $counterValue");
                                //             print(data);
                                //             print('***************************************');
                                //             print("correct answer is : $correctAnswer");
                                //             print("wrong answer is : $wrongAnswer");
                                //             print(textFieldController.text);
                                //           }
                                //           RoutingManager.off('home-page');
                                //         },
                                //         child: Container(
                                //           width: MediaQuery.of(context).size.width * 0.7,
                                //           height: MediaQuery.of(context).size.height * 0.05,
                                //           decoration: BoxDecoration(
                                //               color: AppColors.newPrimeColor,
                                //               borderRadius: BorderRadius.circular(40)),
                                //           child: HeadTitleText(
                                //             'Finish'.toUpperCase(),
                                //             size: 20,
                                //             color: Colors.white, //AppColors.newPrimeColor,
                                //             fontFamily: AppFonts.alatsi,
                                //           ).center(),
                                //         )
                                //     ),
                                //   ],
                                // ),
                              ),
                            ),
                            // isComment == true
                            //     ? Padding(
                            //       padding: EdgeInsets.only(left: Get.width * 0.10, right: Get.width * 0.10, bottom: Get.height * 0.01, top: Get.height * 0.02),
                            //       child: TextField(
                            //         controller: textFieldController,
                            //         cursorColor: AppColors.newPrimeColor,
                            //         textAlignVertical: TextAlignVertical.bottom,
                            //         keyboardType: TextInputType.multiline,
                            //         textInputAction: TextInputAction.newline,
                            //         maxLines: 2,
                            //         maxLength: 150,
                            //         decoration: InputDecoration(
                            //           labelText: 'Comment',
                            //           labelStyle: TextStyle(
                            //             color: AppColors.newPrimeColor
                            //           ),
                            //           enabledBorder: OutlineInputBorder(
                            //               borderRadius: BorderRadius.circular(40),
                            //               borderSide: const BorderSide(color: Colors.black)
                            //           ),
                            //           focusedBorder: OutlineInputBorder(
                            //               borderRadius: BorderRadius.circular(40),
                            //               borderSide: const BorderSide(color: Colors.black)
                            //           ),
                            //           hintText: 'Enter a search term',
                            //         ),
                            //       ),
                            //     )
                            //     : SizedBox()

                          ],
                        ),
                      )
                  ),
                ),
                isStart == false
                    ? Center(child: GestureDetector(
                  onTap: (){
                    questionController.start();
                    quizTimeController.start();
                    setState(() {
                      isStart = true;
                      counterValue = 0;
                    });
                  },
                      child: Container(
                        width: Get.width * 0.7,
                        height: 100,
                        // color: Colors.green,
                          decoration: BoxDecoration(
                              gradient: const LinearGradient(
                                // begin: Alignment.bottomRight,
                                // end: Alignment.centerLeft,
                                  colors: [
                                    Color.fromRGBO(
                                        232, 211, 211, 1), //rgba(232, 211, 211, 1)
                                    Color.fromRGBO(
                                        217, 217, 217, 1), //rgba(217, 217, 217, 1)
                                  ]),
                              borderRadius: BorderRadius.circular(20)),
                        child: Center(
                          child: HeadTitleText(
                            'Ready To Start ',
                            color: AppColors.newPrimeColor,
                            size: 20,
                            fontFamily: AppFonts.alatsi
                          ),
                        ),
                      ),
                    )
                ) : const SizedBox(width: 0,height: 0,),

              ],
            ),
          ),
        ),
      ),
    );
  }
}
// Padding(
//   padding: EdgeInsets.only(top:  Get.height * 0.05 /*121.0*/,left: Get.width * 0.05, right:  Get.width * 0.05),
//   child: GestureDetector(
//     onTap: (){
//       // RoutingManager.to('quizStart');
//     },
//     child: Container(
//       decoration: BoxDecoration(
//           color:  AppColors.quizItem,
//           borderRadius: const BorderRadius.all(
//             Radius.circular(30),
//           ),
//           border: Border.all(
//               color: AppColors.quizItem
//           )
//       ),
//       // height: MediaQuery.of(context).size.height * 0.06,
//       width: MediaQuery.of(context).size.width * 0.9,
//       child: Padding(
//         padding: const EdgeInsets.all(8.0),
//         child: HeadTitleText(
//           'A. The First Answer',
//           size: 20,
//           color: Colors.black,
//           fontFamily: AppFonts.alatsi,
//         ),
//       ),
//     ),
//   ),
// ),
// Padding(
//   padding: EdgeInsets.only(top:  Get.height * 0.02 /*121.0*/,left: Get.width * 0.05, right:  Get.width * 0.05),
//   child: GestureDetector(
//     onTap: (){
//       // RoutingManager.to('quizStart');
//     },
//     child: Container(
//       decoration: BoxDecoration(
//           color:  AppColors.quizItem,
//           borderRadius: const BorderRadius.all(
//             Radius.circular(30),
//           ),
//           border: Border.all(
//               color: AppColors.quizItem
//           )
//       ),
//       // height: MediaQuery.of(context).size.height * 0.06,
//       width: MediaQuery.of(context).size.width * 0.9,
//       child: Padding(
//         padding: const EdgeInsets.all(8.0),
//         child: HeadTitleText(
//           'B. The Second Answer',
//           size: 20,
//           color: Colors.black,
//           fontFamily: AppFonts.alatsi,
//         ),
//       ),
//     ),
//   ),
// ),
// Padding(
//   padding: EdgeInsets.only(top:  Get.height * 0.02 /*121.0*/,left: Get.width * 0.05, right:  Get.width * 0.05),
//   child: GestureDetector(
//     onTap: (){
//       // RoutingManager.to('quizStart');
//     },
//     child: Container(
//       decoration: BoxDecoration(
//           color:  AppColors.quizItem,
//           borderRadius: const BorderRadius.all(
//             Radius.circular(30),
//           ),
//           border: Border.all(
//               color: AppColors.quizItem
//           )
//       ),
//       // height: MediaQuery.of(context).size.height * 0.06,
//       width: MediaQuery.of(context).size.width * 0.9,
//       child: Padding(
//         padding: const EdgeInsets.all(8.0),
//         child: HeadTitleText(
//           'C. The Third Answer',
//           size: 20,
//           color: Colors.black,
//           fontFamily: AppFonts.alatsi,
//         ),
//       ),
//     ),
//   ),
// ),
// Padding(
//   padding: EdgeInsets.only(top:  Get.height * 0.02 /*121.0*/,left: Get.width * 0.05, right:  Get.width * 0.05),
//   child: GestureDetector(
//     onTap: (){
//       // RoutingManager.to('quizStart');
//     },
//     child: Container(
//       decoration: BoxDecoration(
//
//           color:  AppColors.quizItem,
//           borderRadius: const BorderRadius.all(
//             Radius.circular(30),
//           ),
//           border: Border.all(
//               color: AppColors.quizItem
//           )
//       ),
//       width: MediaQuery.of(context).size.width * 0.9,
//       // height: 100,
//       child: Padding(
//         padding: const EdgeInsets.all(8.0),
//         child: HeadTitleText(
//           'D. The Fourth Answer',
//           size: 20,
//           color: Colors.black,
//           fontFamily: AppFonts.alatsi,
//         ),
//       ),
//     ),
//   ),
// ),

/*
currentQuestionIndex + 1 != quizModel.questionNumber
                                        ? GestureDetector(
                                        onTap:  hasAnswer == false ? null : () {
                                          print('on tap');
                                          // print("current Index is + $currentQuestionIndex" );
                                          questionController.start();
                                          quizTimeController.start();
                                          if (isCorrect != 0) {
                                            if (isCorrect == 1) {
                                              setState(() {
                                                correctAnswer++;
                                                // data.add(test);
                                                currentQuestionIndex++;
                                                textFieldController.clear();
                                                counterValue = 0;
                                              });
                                            } else {
                                              setState(() {
                                                wrongAnswer++;
                                                currentQuestionIndex++;
                                                textFieldController.clear();
                                                counterValue = 0;
                                              });
                                            }
                                            print('***************************************');
                                            print("detail of answer $currentQuestionIndex");
                                            print("answer after + $counterValue");
                                            print(data);
                                            print(textFieldController.text);
                                            isCorrect = 0;
                                          }
                                        },
                                        child: Container(
                                          width: MediaQuery.of(context).size.width * 0.7,
                                          height: MediaQuery.of(context).size.height * 0.05,
                                          decoration: BoxDecoration(
                                              color: AppColors.newPrimeColor,
                                              borderRadius: BorderRadius.circular(40)),
                                          child: HeadTitleText(
                                            'Next'.toUpperCase(),
                                            size: 20,
                                            color: Colors.white, //AppColors.newPrimeColor,
                                            fontFamily: AppFonts.alatsi,
                                          ).center(),
                                        ))
                                        : GestureDetector(
                                        onTap: hasAnswer == false ? null : () {
                                          if (isCorrect != 0) {
                                            if (isCorrect == 1) {
                                              setState(() {
                                                correctAnswer++;
                                                counterValue = 0;
                                              });
                                            } else {
                                              setState(() {
                                                wrongAnswer++;
                                                counterValue = 0;
                                              });
                                            }
                                            quizController.updateQuizInfo(data: data, quizId: quizId ?? '');
                                            print('***************************************');
                                            print("detail of answer $currentQuestionIndex");
                                            print("answer after + $counterValue");
                                            print(data);
                                            print('***************************************');
                                            print("correct answer is : $correctAnswer");
                                            print("wrong answer is : $wrongAnswer");
                                            print(textFieldController.text);
                                          }
                                          RoutingManager.off('home-page');
                                        },
                                        child: Container(
                                          width: MediaQuery.of(context).size.width * 0.7,
                                          height: MediaQuery.of(context).size.height * 0.05,
                                          decoration: BoxDecoration(
                                              color: AppColors.newPrimeColor,
                                              borderRadius: BorderRadius.circular(40)),
                                          child: HeadTitleText(
                                            'Finish'.toUpperCase(),
                                            size: 20,
                                            color: Colors.white, //AppColors.newPrimeColor,
                                            fontFamily: AppFonts.alatsi,
                                          ).center(),
                                        )
                                    ),
 */