import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../common/constant/colors.dart';
import '../../../../../common/constant/font.dart';
import '../../../../../common/extensions/widget.dart';
import '../../../../../common/widgets/rx_view.dart';
import '../../../../../common/widgets/text.dart';
import '../../../../../core/routing/routing_manager.dart';
import '../../../../../features/lms/business_logic/lms_controller.dart';
import '../../../../common/widgets/circular_progress_indicator.dart';

class ToDoQuiz extends StatefulWidget {
  const ToDoQuiz(this.subjectId,this.regsId, {super.key});

  final String subjectId;
  final String regsId;

  @override
  State<ToDoQuiz> createState() => _ToDoQuizState();
}

class _ToDoQuizState extends State<ToDoQuiz> {

  LmsController lmsController = Get.find<LmsController>();

  loadData() async{
    await lmsController.getLmsQuiz(widget.subjectId,widget.regsId);

  }
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    // print("\\\\\\\\\\\\\\\\\\ 1 from init state in to do quiz \\\\\\\\\\\\\\\\\\");
    loadData();
    // print("\\\\\\\\\\\\\\\\\\ 2 from init state in to do quiz \\\\\\\\\\\\\\\\\\");
  }



  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Obx( () {
        return lmsController.lmsState.loading ? const CircularProgressIndicatorWidget() : lmsController.lmsState.result.isEmpty
           ? HeadTitleText(
           'no quiz to do'.toUpperCase(),
         color: AppColors.newPrimeColor,
         size: 30,
         fontFamily: AppFonts.alatsi,
                  ).center()
             : 
                  GridView.count(
         childAspectRatio: 500/500,//Get.width * 0.45 / Get.height * 6,
         crossAxisCount: 2,
         shrinkWrap: true,
         children: List.generate(lmsController.lmsState.result.length, (index) {
         return Padding(
           padding: const EdgeInsets.all(8.0),
           child: GestureDetector(
             onTap: (){
               print(lmsController.lmsState.result[index].id);
               RoutingManager.to(
                 'lmsSplash',
                 arguments: lmsController.lmsState.result[index].id,
               );
             },
             child: Container(
               decoration: BoxDecoration(
                   color:  AppColors.quizItem,
                   borderRadius: BorderRadius.circular(20),
                   boxShadow: [
                     BoxShadow(
                       color: AppColors.quizShadow,
                       blurRadius: 1,
                     )
                   ]
               ),
               child: Column(
                 mainAxisAlignment: MainAxisAlignment.spaceBetween,
                 children: [
                   HeadTitleText(
                     'Quiz ${index+1} ',//${widget.subjectId}
                     size: 20,
                     color: AppColors.newPrimeColor,
                     fontFamily: AppFonts.alatsi,
                   ),
                   const Image(image: AssetImage('asset/images/ToDoQuiz.png')),
                 ],
               ).padding(padding: EdgeInsets.symmetric(vertical: Get.height * 0.03)),
             ),
           ),
         );
                  }),
                  );
     
      }
        ),
    );
    //   Obx(
    //         () {
    //           try {
    //             lmsController.getLmsQuiz(widget.subjectId);
    //           } catch (e) {
    //             print(e);
    //           }
    //           return
    //             lmsController.lmsState.loading
    //                 ? Center(
    //               child: CircularProgressIndicator(
    //                 color: AppColors.newPrimeColor,
    //                 backgroundColor: AppColors.newSecondaryColor,
    //               ),
    //             )
    //                 : GridView.count(
    //               childAspectRatio: 500 / 500,
    //               //Get.width * 0.45 / Get.height * 6,
    //               crossAxisCount: 2,
    //               shrinkWrap: true,
    //               children: List.generate(
    //                   lmsController.lmsState.result.length, (index) {
    //                 return Padding(
    //                   padding: const EdgeInsets.all(8.0),
    //                   child: GestureDetector(
    //                     onTap: () {},
    //                     child: Container(
    //                       decoration: BoxDecoration(
    //                           color: AppColors.quizItem,
    //                           borderRadius: BorderRadius.circular(20),
    //                           boxShadow: [
    //                             BoxShadow(
    //                               color: AppColors.quizShadow,
    //                               blurRadius: 1,
    //                             )
    //                           ]
    //                       ),
    //                       child: Column(
    //                         mainAxisAlignment: MainAxisAlignment.spaceBetween,
    //                         // mainAxisAlignment: MainAxisAlignment.center,
    //                         children: [
    //                           HeadTitleText(
    //                             'Quiz ${index + 1} id ${lmsController.lmsState
    //                                 .subject}',
    //                             size: 20,
    //                             color: AppColors.newPrimeColor,
    //                             fontFamily: AppFonts.alatsi,
    //                           ),
    //                           const Image(image: AssetImage(
    //                               'asset/images/ToDoQuiz.png')),
    //                           // SizedBox(height: 5,)
    //                           // Container()
    //                         ],
    //                       ).padding(padding: EdgeInsets.symmetric(
    //                           vertical: Get.height * 0.03)),
    //                     ),
    //                   ),
    //                   // selectMeal(mealInfo[index],index),
    //                 );
    //               }),
    //             );
    //         }
    // )
    // );
  }
}
