import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../features/new_purchase/data/model/new_weeklyPurchase_model.dart';
import '../../../../../../features/new_purchase/data/service/new_purchase_service.dart';

class NewPurchaseController extends GetxController {

  NewPurchaseService newPurchaseService = NewPurchaseService();
  RxFuture<NewWeeklyPurchaseModel> newPurchaseState = RxFuture(NewWeeklyPurchaseModel.zero());
  Map<String,NewPurchaseDaily> purchaseMap = <String,NewPurchaseDaily>{};

  Future<void> getPurchaseTable(String registrationRecordId) async{
    Future.delayed(Duration.zero, () async {
      await newPurchaseState.observe(
          (p0) async {
            return await newPurchaseService.getNewPurchaseDetail(registrationRecordId);
          },
        onSuccess: (value) {
          print(".............. Start the get new Weekly Purchase Table in new controller ..............");
          print(value);
          purchaseMap = value.weeklyPurchases;
          // purchaseMap['Sunday'] = value.getNewPurchase('Sunday');
          // purchaseMap['Monday'] = value.getNewPurchase('Monday');
          // purchaseMap['Tuesday'] = value.getNewPurchase('Tuesday');
          // purchaseMap['Wednesday'] = value.getNewPurchase('Wednesday');
          // purchaseMap['Thursday'] = value.getNewPurchase('Thursday');
          print(purchaseMap.length);
          print(".............. End the get new Weekly Purchase Table in new controller ..............");
        },
        onError: (p0){
            print(p0.toString());
        snackBarWidget("Ooop's somthing wrong", p0.toString());
      }
      );
    });
  }


}