import 'package:intl/intl.dart';
import '../../../../../../common/constant/apis.dart';
import '../../../../../../core/network/http.dart';
import '../../../../../../features/new_purchase/data/model/new_weeklyPurchase_model.dart';
import '../../../../../../helpers/date_helpers.dart';

class NewPurchaseService {

  Future<NewWeeklyPurchaseModel> getNewPurchaseDetail(String regId) async{
    Request request = Request(
      EndPoints.getNewPurchase,
      RequestMethod.get,
      authorized: true,
        queryParams: {
          "registration_record_id": regId,
          "from": DateFormat('y-MM-d').format(DateHerlpers.getFirstSunday(DateTime.now()).subtract(const Duration(days: 7))),
          "to": DateFormat('y-MM-d').format(DateHerlpers.getFirstThursday(DateTime.now())),
          "paginated" : "false",
          // "group_by":  "date"
      }
    );
    // print('befor response');
    Map<String,dynamic> response = await request.sendRequest();
    // print(response);
    // print('after response');

    return NewWeeklyPurchaseModel.fromJson(response);
  }



}