import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/constant/font.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../core/routing/routing_manager.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/new_purchase/buisness_logic/new_purchase_controller.dart';
import '../../../../../../features/new_purchase/data/model/new_weeklyPurchase_model.dart';

class NewWeeklyPurchase extends StatefulWidget {
  const NewWeeklyPurchase({super.key});

  @override
  State<NewWeeklyPurchase> createState() => _NewWeeklyPurchaseState();
}

class _NewWeeklyPurchaseState extends State<NewWeeklyPurchase> {
  final NewPurchaseController newPurchaseController = Get.find<NewPurchaseController>();
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();

  List<bool> isExpanded = List.generate(5, (_) => false);
  final List<String> days = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday'];

  @override
  void initState() {
    super.initState();
    newPurchaseController.getPurchaseTable(
      authController.childrens[homeController.selectedChild.value].id,
    );
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
        color: Color.fromRGBO(238, 238, 238, 1),
        image: DecorationImage(
          image: AssetImage('asset/images/backGroundLogIn1.png'),
          fit: BoxFit.cover,
        ),
      ),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          scrolledUnderElevation: 0,
          title: Center(
            child: HeadTitleText(
              'Weekly Purchase',
              size: 20,
              color: AppColors.newPrimeColor,
              fontFamily: AppFonts.alatsi,
            ),
          ),
          leading: IconButton(
            onPressed: RoutingManager.back,
            icon: Icon(
              Icons.arrow_back,
              size: 35,
              color: AppColors.newPrimeColor,
            ),
          ),
        ),
        body: Obx(() {
          if (newPurchaseController.newPurchaseState.loading) {
            return Center(
              child: CircularProgressIndicator(
                backgroundColor: AppColors.quizItem,
                color: AppColors.newPrimeColor,
              ),
            );
          }

          return SingleChildScrollView(
            child: Column(
              children: List.generate(days.length, (dayIndex) {
                final dayName = days[dayIndex];
                final purchaseData = newPurchaseController.purchaseMap[dayName];

                if (purchaseData == null) {
                  return const SizedBox();
                }

                return Padding(
                  padding: EdgeInsets.symmetric(
                    horizontal: Get.width * .05,
                    vertical: Get.height * .02,
                  ),
                  child: InkWell(
                    highlightColor: Colors.transparent,
                    borderRadius: BorderRadius.circular(20),
                    onTap: () {
                      setState(() {
                        isExpanded[dayIndex] = !isExpanded[dayIndex];
                      });
                    },
                    child: AnimatedContainer(
                      duration: const Duration(milliseconds: 250),
                      height: isExpanded[dayIndex] ? Get.height * .52 : Get.height * .06,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(20),
                        color: AppColors.quizItem,
                      ),
                      child: isExpanded[dayIndex]
                          ? _buildExpandedDay(purchaseData, dayName)
                          : _buildCollapsedDay(dayName, purchaseData.weeklyPurchases.length),
                    ),
                  ),
                );
              }),
            ),
          );
        }),
      ),
    );
  }

  Widget _buildCollapsedDay(String dayName, int count) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          HeadTitleText(
            dayName.tr,
            size: 18,
            color: AppColors.newPrimeColor,
            fontFamily: AppFonts.alatsi,
          ),
          HeadTitleText(
            count.toString(),
            size: 18,
            color: AppColors.newPrimeColor,
            fontFamily: AppFonts.alatsi,
          ),
        ],
      ),
    );
  }

  Widget _buildExpandedDay(NewPurchaseDaily purchaseData, String dayName) {
    return Padding(
      padding: EdgeInsets.all(Get.width * .02),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              HeadTitleText(
                dayName.tr,
                size: 20,
                color: AppColors.newPrimeColor,
                fontFamily: AppFonts.alatsi,
              ),
              HeadTitleText(
                purchaseData.date.toString(),
                size: 20,
                color: AppColors.newPrimeColor,
                fontFamily: AppFonts.alatsi,
              ),
            ],
          ),
          SizedBox(height: Get.height * .02),
          SizedBox(
            height: Get.height * .40,
            child: purchaseData.weeklyPurchases.isEmpty
                ? Center(
                    child: HeadTitleText(
                      'There are no purchases for this day',
                      size: 18,
                      color: AppColors.newPrimeColor,
                      fontFamily: AppFonts.alatsi,
                    ),
                  )
                : ListView.builder(
                    itemCount: purchaseData.weeklyPurchases.length,
                    itemBuilder: (context, index) {
                      final item = purchaseData.weeklyPurchases[index];

                      return Card(
                        child: Padding(
                          padding: const EdgeInsets.symmetric(vertical: 8.0,horizontal: 8.0),
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              SizedBox(
                                width: Get.width * .33,
                                child: Center(
                                  child: HeadTitleText(
                                    item.mealName,
                                    size: 20,
                                    fontFamily: AppFonts.alatsi,
                                  ),
                                ),
                              ),
                              SizedBox(
                                width: Get.width * .15,
                                child: Center(
                                  child: HeadTitleText(
                                    item.quantity,
                                    size: 20,
                                    fontFamily: AppFonts.alatsi,
                                  ),
                                ),
                              ),
                              SizedBox(
                                width: Get.width * .30,
                                child: Center(
                                  child: HeadTitleText(
                                    '${item.price} ${item.coin}',
                                    size: 20,
                                    fontFamily: AppFonts.alatsi,
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ),
                      );
                    },
                  ),
          ),
        ],
      ),
    );
  }
}
