import '../../../../../../features/notes/data/model/note.dart';
import '../../../../../../features/restaurant/data/model/date.dart';

import '../../../../common/constant/apis.dart';
import '../../../../core/network/http.dart';

class NoteService {
  DateModel dateModel = DateModel.zero();
  Future<List<NoteResponse>> getNotes(Map<String, dynamic> params) async {
    Request request = Request(
      EndPoints.getNotes,
      RequestMethod.get,
      authorized: true,
      queryParams: params.isEmpty ? null : params,
    );
    Map<String, dynamic> response = await request.sendRequest();
    return NoteResponse.fromJsonList(response, 'notes');
  }

  Future<NoteResponse> getSingleNote(String id) async {
    Request request = Request(
      '${EndPoints.getNotes}/$id',
      RequestMethod.get,
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    return NoteResponse.fromJson(response['data']);
  }
}
