import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/note_types.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/notes/business_logic/note_controller.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/dropdown.dart';

class DropDownNotes extends StatelessWidget {
  DropDownNotes({super.key});
  final NoteController noteController = Get.find<NoteController>();
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();
  @override
  Widget build(BuildContext context) {
    return Container(alignment: Alignment.topCenter,
      padding: const EdgeInsets.only(left: 16, right: 16 ),
      width: Get.width * .85,
      height: 45,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(25),
        border: Border.all(color: AppColors.secondaryColor)),
      child: DropDownWidget<String>(
        padding: const EdgeInsets.only(bottom: 30),
        margin: const EdgeInsets.only(bottom: 6),
        item: [
          "All Notes".tr,
          "Medical notes".tr,
          "Study Notes".tr,
          "Psychological note".tr
        ],
        onChanged: (value) {
          if (value == 'All Notes'.tr) {
            noteController.getNotes(
              {
                'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
                'size': 25, 
              },
            );
          } else if (value == 'الملاحظات الطبية' || value == 'Medical notes') {
            noteController.getNotes(
              {
                'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
                'type': 'medical',
                'size': 25,
              },
            );
          } else if (value == 'الملاحظات الدراسية' || value == 'Study Notes') {
            noteController.getNotes(
              {
                'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
                'type': 'educational',
                'size': 25,
              },
            );
          } else if (value == "الملاحظات النفسية" || value == 'Psychological note') {
            noteController.getNotes(
              {
                'registration_record_id': authController.childrens[homeController.selectedChild.value].id,
                'type': NOTE_TYPE_PSYCHOLOGICAL,
                'size': 25,
              },
            );
          }
        },
        selectItem: "All Notes".tr,
      ),
    );
  }
}
