import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:get/get.dart';
import '../../../../../../features/class/presentation/widgets/attachment_widget.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';
import '../../data/model/note.dart';

class NoteBodyWidget extends StatelessWidget {
  final NoteResponse note;

  const NoteBodyWidget({
    super.key,
    required this.note,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(
      builder: (context, constraints) {
        final double width = constraints.maxWidth;
        final bool hasAttachment = note.attachment.name.isNotEmpty;

        return Container(
          margin: EdgeInsets.only(bottom: width * 0.05),
          width: width,
          decoration: BoxDecoration(
            border: Border.all(color: AppColors.primeColor),
            borderRadius: BorderRadius.circular(10),
          ),
          child: Padding(
            padding: EdgeInsets.symmetric(
              horizontal: width * 0.03,
              vertical: width * 0.03,
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                /// ---- Header ----
                Row(
                  children: [
                    TextTitle(
                      note.name.tr,
                      textColor: AppColors.secondaryColor,
                      size: width * 0.045,
                    ).expanded(6),
                    NormalText(
                      note.date.tr,
                      textColor: AppColors.secondaryColor.withOpacity(0.5),
                      size: width * 0.035,
                    ).expanded(3),
                    SvgPicture.asset(
                      'asset/icons/Info Circle.svg',
                      color: AppColors.primeColor,
                      width: width * 0.05,
                    ).expanded(1),
                  ],
                ),

                /// ---- Type ----
                NormalText(
                  note.type.tr,
                  textColor: AppColors.secondaryColor.withOpacity(0.5),
                  size: width * 0.035,
                ).padding(padding: EdgeInsets.only(bottom: width * 0.01)),

                Text(
                  note.note,
                  maxLines: 50,
                  overflow: TextOverflow.ellipsis,
                  style: TextStyle(
                    fontSize: width * 0.035,
                    color: AppColors.secondaryColor.withOpacity(0.6),
                  ),
                ),

                SizedBox(height: width * 0.04),
                if (hasAttachment)
                  SizedBox(
                    height: width * 0.62, 
                    child: AttachmentWidget(
                      attachmentModel: note.attachment,
                    ),
                  ),
              ],
            ),
          ),
        );
      },
    );
  }
}
