import 'package:get/get.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../features/notification/data/model/notification.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../features/notification/data/service/notifications_service.dart';

class NotificationController extends GetxController {
  // get notifications****************

  RxFuture<List<NotificationResponse>> notificationState = RxFuture([]);
  NotificationService notificationService = NotificationService();
  Future<void> getNotifications() async {
    Future.delayed(
      Duration(seconds: 1),
      ()async{
        await notificationState.observe(
      (_) async {
        return await notificationService.getNotifications();
      },
      onError: (p0) {
        snackBarWidget('something wrong', p0.toString());
      },
    );
      }
    );
       
  }
}
