import '../../../../../../common/constant/apis.dart';
import '../../../../../../core/network/http.dart';

import '../model/notification.dart';

class NotificationService {
  Future<List<NotificationResponse>> getNotifications() async {
    Request request = Request(
      EndPoints.getNotification,
      RequestMethod.get,
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    return NotificationResponse.fromJsonList(response, 'data');
  }
}
