import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/notes/business_logic/note_controller.dart';
import '../../../../common/widgets/rx_view.dart';
import '../../business_logic/notification_controller.dart';
import '../widgets/notification_details.dart';

class NotificationPage extends StatefulWidget {

  NotificationPage({super.key});

  @override
  State<NotificationPage> createState() => _NotificationPageState();
}

class _NotificationPageState extends State<NotificationPage> {
  final NotificationController notificationController =
      Get.find<NotificationController>();

  NoteController noteController = Get.find<NoteController>();
  AuthController authController = Get.find<AuthController>();
  HomeController homeController = Get.find<HomeController>();


  loadData()async{

    await notificationController.getNotifications();
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }
  @override
  Widget build(BuildContext context) {
  //  notificationController.getNotifications();
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
             backgroundColor: Colors.transparent,
                    leading: IconButton(
                      icon: const Icon(Icons.arrow_back),
                      color: AppColors.newPrimeColor,
                      onPressed: () {
                        Navigator.pop(context);
                      },
                    ),
                    title: Center(
                      child: HeadTitleText(
                        'Notification'.toUpperCase(),
                        color: AppColors.newPrimeColor,
                        fontFamily: 'alatsi',
                      ).padding(
                          padding: const EdgeInsets.only(right: 50, bottom: 10)),
                    ),

          ),
        body: SingleChildScrollView(
          child: Column(
            children: [
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 0),
                child: SizedBox(
                    height: Get.height,
                    width: Get.width,
                    child: Obx(() {
                      return notificationController.notificationState.loading
                      ?Center(child: CircularProgressIndicator(
                        backgroundColor: AppColors.quizItem,
                        color: AppColors.newPrimeColor,
                      ))
                      : ListView.separated(
                          itemBuilder: (BuildContext context, index) {
                            return NotificationDetails(
                              notificationModel: notificationController
                                  .notificationState.result[index],
                            );
                          },
                          separatorBuilder: (BuildContext context, index) {
                            return const Divider(
                              color: Colors.transparent,
                              height: 0,
                              thickness: 0,
                            );
                          },
                          itemCount: notificationController
                              .notificationState.result.length);
                        RxView(
                          rxFuture: notificationController.notificationState,
                          onRetry: () {
                            notificationController.getNotifications();
                          },
                          child: ListView.separated(
                              itemBuilder: (BuildContext context, index) {
                                return NotificationDetails(
                                  notificationModel: notificationController
                                      .notificationState.result[index],
                                );
                              },
                              separatorBuilder: (BuildContext context, index) {
                                return const Divider(
                                  color: Colors.transparent,
                                  height: 0,
                                  thickness: 0,
                                );
                              },
                              itemCount: notificationController
                                  .notificationState.result.length));
                    })

                    ),
              )
            ],
          ),
        ),
      ),
    );
  }
}
