import '../../../../../../features/purchase/models/purchase_item_model.dart';

class DayPurchaseModel {
  DayPurchaseModel({
    required this.date,
    required this.day,
    required this.history,
  });
  late final DateTime date;
  late final String day;
  late final List<PurchaseItem> history;

  DayPurchaseModel.fromJson(Map<String, dynamic> json) {
    date = DateTime.parse(json['date']);
    day = json['day'];

    List<dynamic> purchase = json['history'];
    history = List.generate(purchase.length, (index) => PurchaseItem.fromJson(purchase[index]));
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['date'] = date;
    data['day'] = day;
    data['history'] = history;
    return data;
  }
}
