import 'dart:developer';


import '../../../../../../features/purchase/api_res.dart';
import '../../../../../../features/purchase/models/buffet_card_model.dart';
import '../../../../../../features/purchase/models/day_purchase_model.dart';
import '../../../../../../features/purchase/models/purchase_item_model.dart';
import '../../../../../../features/restaurant/data/source/restaurant_web.dart';
import '../../../../../../utils/ui_utils.dart';
import 'package:flutter/foundation.dart';

class PurchaseNotifier extends ChangeNotifier {
  RestaurantWebService restaurantRepo = RestaurantWebService();
  int daily_limit = 0;
  bool isLoading = false;
  late RestaurantWebService buffetWebService = RestaurantWebService();
  BuffetCardModel? buffetCardModel;
  List<PurchaseItem> thisDayPurchase = [];
  List<DayPurchaseModel> weekPurchaseList = [];
  int tempDailyLimit = 0;
  late DateTime _date = DateTime.now();
  DateTime get date => _date;

  num get thisDayTotalAmount {
    num total = 0;
    for (PurchaseItem p in thisDayPurchase) {
      if(p.type == "buy"){
      total += p.totalAmount; 

        }else if(p.type == "return"){
      total -= p.totalAmount; 

      } 
    }
    return total;
  }

  Future<void> getStudentDailyLimit(registrationRecordId) async {
    isLoading = true;
    daily_limit = await restaurantRepo.getStudentDailyLimet(
          registrationRecordId: registrationRecordId,
        );
        tempDailyLimit = daily_limit;
        isLoading = false;
  }

  Future<void> getBuffetCard({
    required String childId,
    String? type,
    DateTime? date,
  }) async {
    isLoading = true;
    notifyListeners();
    log('getBuffetCard');
     ApiResponse apiResponse = await buffetWebService.getBuffetCard(
      childId: childId,
    );
    
      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');
      //
      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');
      // print(apiResponse.data);
      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');
      //
      // print('ligwkgnrkkngkrngerngergerngperngpergperngperngpknerpggnergnerpngpe');
    if (apiResponse.errorMessage != null) {
      // UiUtils.showToast(apiResponse.errorMessage!);
      log('Api Response : ${apiResponse.errorMessage!}');
      
      buffetCardModel = null;
      notifyListeners();
      isLoading = false;
    } else {
      BuffetCardModel buffetCardo = BuffetCardModel.fromJson(apiResponse.data);
      buffetCardModel = buffetCardo;
     
     
      notifyListeners();
       isLoading = false;
    }
  }

  Future<void> getThisDayPurchase({
    required int childId,
    DateTime? date,
  }) async {
    isLoading = true;
    _date = date ?? DateTime.now();
    notifyListeners();
    log('getThisDayPurchase');
    ApiResponse apiResponse = await buffetWebService.getPurchaseByDay(
      childId: childId,
      date: date ?? DateTime.now(),
    );

    if (apiResponse.errorMessage != null) {
      // UiUtils.showToast(apiResponse.errorMessage!);
      log('Api Response : ${apiResponse.errorMessage!}');
    } else {
      thisDayPurchase = apiResponse.data;
    }

    isLoading = false;
    notifyListeners();
  }

  Future<void> getWeekPurchase({
    required int childId,
  }) async {
    isLoading = true;
    notifyListeners();

    ApiResponse apiResponse = await buffetWebService.getPurchaseByWeek(
      childId: childId,
    );

    if (apiResponse.errorMessage != null) {
      UiUtils.showToast(apiResponse.errorMessage!);
    } else {
      weekPurchaseList = apiResponse.data;
      log('weekPurchaseList');
      log('             1');
      log('             2');
      log('${weekPurchaseList.length}');
      log('             3');
      log('             4');
    }

    isLoading = false;
    notifyListeners();
  }

  addToTempDailyLimit() {
    tempDailyLimit = tempDailyLimit + 500;
    notifyListeners();
    }

  minusToTempDailyLimit() {
    if (tempDailyLimit == 0) return;
    tempDailyLimit = tempDailyLimit - 500;
    notifyListeners();
    }

  void resetTempDailyLimit() {
    tempDailyLimit = daily_limit;
  }

  Future<void> updateDailyLimit({required int childId, required int newDailyLimit1}) async {
    isLoading = true;
    notifyListeners();

    ApiResponse apiResponse = await buffetWebService.updateDailyLimit(
      childId: childId,
      newDailyLimit: newDailyLimit1,
    );

    if (apiResponse.errorMessage != null) {
      UiUtils.showToast(apiResponse.errorMessage!);
    } else {
      daily_limit = newDailyLimit1;
    }

    isLoading = false;
    notifyListeners();
    }
}
