import 'package:auto_size_text/auto_size_text.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/constant/font.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../core/routing/routing_manager.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/new_purchase/buisness_logic/new_purchase_controller.dart';
import '../../../../../../features/restaurant/business_logic/restaurant_controller.dart';
import '../../../../../../features/purchase/purchase_notifier.dart';
import '../../../../../../features/purchase/screens/set_daily_limit_screen.dart';
import '../../../../../../features/purchase/widgets/purchase_screen_button.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import '../../../core/local storage/local_storage.dart';

class PurchaseScreenMiddleware extends GetMiddleware {
   late int daily_limit;
   late int balance;
  @override
  Widget onPageBuilt(Widget page) {
    final RestaurantController restaurantController = Get.find<RestaurantController>();
    final AuthController authController = Get.find<AuthController>();
    final HomeController homeController = Get.find<HomeController>();
    // final NewPurchaseController newPurchaseController = Get.find<NewPurchaseController>();
    final  PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());

    restaurantController.setRegistrationRecord(
      authController.childrens[homeController.selectedChild.value].id,
    );
    WidgetsBinding.instance.addPostFrameCallback((_) async {
       restaurantController.setRegistrationRecord(
      authController.childrens[homeController.selectedChild.value].id,
    );
      await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
      await  purchaseNotifier.getBuffetCard(
            childId: authController
                        .childrens[homeController.selectedChild.value].id);

      await  purchaseNotifier.getThisDayPurchase(
          childId: int.parse(authController
                        .childrens[homeController.selectedChild.value].id),
        );
       /////***************add  */
    });

    return super.onPageBuilt(page);
  }
}

class PurchaseScreen extends StatefulWidget {
  
  const PurchaseScreen({Key? key}) : super(key: key);
  
  @override
  _PurchaseScreen createState() => _PurchaseScreen();
}

class _PurchaseScreen extends State<PurchaseScreen> {
    final  PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());
    final HomeController homeController = Get.find<HomeController>();
    final AuthController authController = Get.find<AuthController>();
    final RestaurantController restaurantController = Get.find<RestaurantController>();
    final NewPurchaseController newPurchaseController = Get.find<NewPurchaseController>();

String? typeUser;
    // DateTime _selectedDay = DateTime.now();
    String date = '';
    String nameDay = DateFormat('EEEE').format(DateTime.now());
    int totalPayment = 0;

    void loadData() async{
      print("-*-*-*-*-*-*");
      print(nameDay);
      restaurantController.setRegistrationRecord(
        authController.childrens[homeController.selectedChild.value].id,
      );
      await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
      await  purchaseNotifier.getBuffetCard(
          childId: authController
              .childrens[homeController.selectedChild.value].id);
      await  purchaseNotifier.getThisDayPurchase(
        childId: int.parse(authController
            .childrens[homeController.selectedChild.value].id),
      );
      await newPurchaseController.getPurchaseTable(
          authController.childrens[homeController.selectedChild.value].id);


      for (var i = 0; i < newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases.length; i++) {
        totalPayment = totalPayment + newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[i].price;
      }
   }


   @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
        typeUser = LocalStorage().userTypeUser;

  }

  @override
  Widget build(BuildContext context) {
    return  RefreshIndicator(
      onRefresh:  () async {
        loadData();
        totalPayment = 0;
      },
      child: Container(
        decoration: const BoxDecoration(
            color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
            image: DecorationImage(
                image: AssetImage('asset/images/backGroundLogIn1.png'),
                fit: BoxFit.cover)
        ),
        child: Scaffold(
          backgroundColor: Colors.transparent,
          body:
          Column(
            mainAxisAlignment: MainAxisAlignment.spaceEvenly,
            children: [
              Container(
                height: MediaQuery.of(context).size.height * 0.46,
                width: MediaQuery.of(context).size.width * 0.8,
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(15),
                  color: const Color(0xffD4B5B3),//AppColors.primeColor.withOpacity(0.9),
                  boxShadow: [
                    BoxShadow(
                      color: Colors.grey.withAlpha(150),
                      blurRadius: 10,
                      spreadRadius: 0.1,
                      offset: const Offset(0, 5),
                    ),
                  ],
                ),
                child: Obx((){
                  return newPurchaseController.newPurchaseState.loading
                  ? Center(
                    child: CircularProgressIndicator(
                      backgroundColor: AppColors.quizItem,
                      color: AppColors.newPrimeColor,
                    ),
                  )
                   : newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases.isEmpty
                      ? Center(child: Text('purchase_empty'.tr))
                      : ListView.builder(
                    itemCount: newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases.length,
                    itemBuilder: (context, index) {

                      // setState(() {
                      //   // int price = int.parse(newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].price);
                      //   // int quantity = int.parse(newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].quantity);
                      // totalPayment = totalPayment + newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].price;
                      // });
                      return Column(
                        children: [
                          Padding(
                            padding: const EdgeInsets.symmetric(vertical: 8.0),
                            child: Container(
                              width: Get.width,
                              height: Get.height * .15,
                              child: Padding(
                                padding: EdgeInsets.symmetric(horizontal: 10.0),
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.spaceAround,
                                  children: [
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        HeadTitleText(
                                          'Meals name: ',
                                          size: 15,
                                          fontFamily: AppFonts.alatsi,
                                        ),
                                        Container(
                                          width: Get.width / 2,
                                          child: Center(
                                            child: AutoSizeText(
                                              '${newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].mealName}',
                                              maxLines: 2,
                                              maxFontSize: 15,
                                              minFontSize: 10,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        HeadTitleText(
                                          'Quantity: ',
                                          size: 15,
                                          fontFamily: AppFonts.alatsi,
                                        ),
                                        Container(
                                          width: Get.width /2,
                                          child: Center(
                                            child: HeadTitleText(
                                              '${newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].quantity}',
                                              size: 15,
                                              fontFamily: AppFonts.alatsi,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        HeadTitleText(
                                          'Price: : ',
                                          size: 15,
                                          fontFamily: AppFonts.alatsi,
                                        ),
                                        Container(
                                          width: Get.width /2,
                                          child: Center(
                                            child: HeadTitleText(
                                              '${newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].price}',
                                              size: 15,
                                              fontFamily: AppFonts.alatsi,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          Divider(
                            color: Colors.grey,
                            indent: 10,
                            endIndent: 5,
                          )
                        ],
                      );
                    },
                  );
                })
              ),
              Container(
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(15),
                    // color: AppColors.primeColor,
                    gradient: const LinearGradient(
                        begin: Alignment.centerRight,
                        end: Alignment.topRight,
                        colors: [
                          Color.fromRGBO(232, 211, 211, 1),
                          Color.fromRGBO(217, 217, 217, 1),
                        ]
                    )
                ),
                padding: const EdgeInsets.symmetric(
                    horizontal: 16, vertical: 8),
                child: Obx((){
                  return
                    // newPurchaseController.newPurchaseState.loading
                    //   ? Padding(
                    //     padding: const EdgeInsets.symmetric(horizontal: 30, vertical: 6),
                    //     child: CircularProgressIndicator(
                    //       backgroundColor: AppColors.quizItem,
                    //       color: AppColors.newPrimeColor,
                    //     ),
                    //   )
                    //   :
                  Column(
                    children: newPurchaseController.newPurchaseState.loading
                        ? [
                          Padding(
                            padding: const EdgeInsets.symmetric(horizontal: 30, vertical: 6),
                            child: CircularProgressIndicator(
                              backgroundColor: AppColors.quizItem,
                              color: AppColors.newPrimeColor,
                            ),
                          )
                    ] : [
                      Text(
                        'Total payment'.tr,
                        style: TextStyle(
                            color: AppColors.newPrimeColor,//Colors.white,
                            fontSize: 14,
                            height: 1.2,
                            fontFamily: AppFonts.alatsi
                        ),
                      ),
                      const SizedBox(
                        height: 5,
                      ),
                      Text(
                        '${totalPayment}',
                        style: TextStyle(
                            color: AppColors.newPrimeColor,//Colors.white,
                            fontWeight: FontWeight.bold,
                            fontSize: 18,
                            height: 1.2,
                            fontFamily: AppFonts.alatsi
                        ),
                      ),
                    ],
                  );
                })
              ),
              Padding(
                padding: EdgeInsets.symmetric(horizontal: Get.width *.02),
                child: Row(
                  children: [
                    PurchaseScreenButton(
                        onPressed:  () {
                          if(typeUser == 'parent') {
                            Navigator.of(context).push(
                              MaterialPageRoute(
                                  builder: (context) =>
                                  const SetDailyLimitScreen()));
                          }
                        },
                        title: 'Settings'.tr),
                    const SizedBox(width: 16),
                    PurchaseScreenButton(
                      onPressed: () async{
                        await newPurchaseController.getPurchaseTable(authController.childrens[homeController.selectedChild.value].id);
                        RoutingManager.to(RoutesName.newWeeklyPurchase);
                      },
                      title: 'Weekly purchase'.tr,
                    ),
                    // SizedBox(width: 16),
                    // PurchaseScreenButton(onPressed: () {}, title: 'جميع المشتريات'),
                  ],
                ),
              ),
            ],
          ),



        )
      ),
    );
 }

}

/*
newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases.isEmpty
                      ? Center(child: Text('purchase_empty'.tr))
                      : ListView.builder(
                    itemCount: newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases.length,
                    itemBuilder: (context, index) {

                      // setState(() {
                      //   // int price = int.parse(newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].price);
                      //   // int quantity = int.parse(newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].quantity);
                        totalPayment += newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].price;
                      // });
                      return Column(
                        children: [
                          Padding(
                            padding: const EdgeInsets.symmetric(vertical: 8.0),
                            child: Container(
                              width: Get.width,
                              height: Get.height * .15,
                              child: Padding(
                                padding: EdgeInsets.symmetric(horizontal: 10.0),
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.spaceAround,
                                  children: [
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        HeadTitleText(
                                          'Meals name: ',
                                          size: 15,
                                          fontFamily: AppFonts.alatsi,
                                        ),
                                        Container(
                                          width: Get.width / 2,
                                          child: Center(
                                            child: AutoSizeText(
                                              '${newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].mealName}',
                                              maxLines: 2,
                                              maxFontSize: 15,
                                              minFontSize: 10,
                                            ),
                                          ),
                                        ),

                                      ],
                                    ),
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        HeadTitleText(
                                          'Quantity: ',
                                          size: 15,
                                          fontFamily: AppFonts.alatsi,
                                        ),
                                        Container(
                                          width: Get.width /2,
                                          child: Center(
                                            child: HeadTitleText(
                                              '${newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].quantity}',
                                              size: 15,
                                              fontFamily: AppFonts.alatsi,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        HeadTitleText(
                                          'Price: : ',
                                          size: 15,
                                          fontFamily: AppFonts.alatsi,
                                        ),
                                        Container(
                                          width: Get.width /2,
                                          child: Center(
                                            child: HeadTitleText(
                                              '${newPurchaseController.purchaseMap[nameDay]!.weeklyPurchases[index].price}',
                                              size: 15,
                                              fontFamily: AppFonts.alatsi,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          ),
                          Divider(
                            color: Colors.grey,
                            indent: 10,
                            endIndent: 5,
                          )
                        ],
                      );
                    },
                  ),
 */
// for use now 1
/*
const SizedBox(height: 16),
                      Container(
                        height: MediaQuery.of(context).size.height * 0.5,
                        width: MediaQuery.of(context).size.width * 0.8,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          color: const Color(0xffD4B5B3),//AppColors.primeColor.withOpacity(0.9),
                          boxShadow: [
                            BoxShadow(
                              color: Colors.grey.withAlpha(150),
                              blurRadius: 10,
                              spreadRadius: 0.1,
                              offset: const Offset(0, 5),
                            ),
                          ],
                        ),
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(15),
                          child: purchaseNotifier.thisDayPurchase.isNotEmpty
                              ? ListView.builder(
                            itemCount: purchaseNotifier
                                .thisDayPurchase.length,
                            itemBuilder: (context, index) {
                              log('${purchaseNotifier.thisDayPurchase.length}');
                              return PurchaseListItem(
                                purchaseItem: purchaseNotifier
                                    .thisDayPurchase[index],
                              );
                              },
                          )
                              : Center(child: Text('purchase_empty'.tr)),
                        ),
                      ),
                      const SizedBox(height: 32),




 */

// for use now 2
/*
Column(
                    children: [
                      const SizedBox(height: 16),
                      Container(
                        height: MediaQuery.of(context).size.height * 0.5,
                        width: MediaQuery.of(context).size.width * 0.8,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          color: const Color(0xffD4B5B3),//AppColors.primeColor.withOpacity(0.9),
                          boxShadow: [
                            BoxShadow(
                              color: Colors.grey.withAlpha(150),
                              blurRadius: 10,
                              spreadRadius: 0.1,
                              offset: const Offset(0, 5),
                            ),
                          ],
                        ),
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(15),
                          child: purchaseNotifier.thisDayPurchase.isNotEmpty
                              ? ListView.builder(
                            itemCount: purchaseNotifier
                                .thisDayPurchase.length,
                            itemBuilder: (context, index) {
                              log('${purchaseNotifier.thisDayPurchase.length}');
                              return PurchaseListItem(
                                purchaseItem: purchaseNotifier
                                    .thisDayPurchase[index],
                              );
                              },
                          )
                              : Center(child: Text('purchase_empty'.tr)),
                        ),
                      ),
                      const SizedBox(height: 32),
                      Container(
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          // color: AppColors.primeColor,
                            gradient: const LinearGradient(
                                begin: Alignment.centerRight,
                                end: Alignment.topRight,
                                colors: [
                                  Color.fromRGBO(232, 211, 211, 1),
                                  Color.fromRGBO(217, 217, 217, 1),
                                ]
                            )
                        ),
                        padding: const EdgeInsets.symmetric(
                            horizontal: 16, vertical: 8),
                        child: Column(
                          children: [
                            Text(
                              'Total payment'.tr,
                              style: TextStyle(
                                color: AppColors.newPrimeColor,//Colors.white,
                                fontSize: 14,
                                height: 1.2,
                                fontFamily: AppFonts.alatsi
                              ),
                            ),
                            const SizedBox(
                              height: 5,
                            ),
                            Text(
                              purchaseNotifier.thisDayTotalAmount
                                  .toString(),
                              style: TextStyle(
                                color: AppColors.newPrimeColor,//Colors.white,
                                fontWeight: FontWeight.bold,
                                fontSize: 18,
                                height: 1.2,
                                fontFamily: AppFonts.alatsi
                              ),
                            ),
                          ],
                        ),
                      ),
                      Padding(
                        padding: const EdgeInsets.all(16.0),
                        child: Row(
                          children: [
                            PurchaseScreenButton(
                                onPressed: () {
                                  Navigator.of(context).push(
                                      MaterialPageRoute(
                                          builder: (context) =>
                                          const SetDailyLimitScreen()));
                                  },
                                title: 'settings'.tr),
                            const SizedBox(width: 16),
                            PurchaseScreenButton(
                              onPressed: () async{
                                await newPurchaseController.getPurchaseTable(authController.childrens[homeController.selectedChild.value].id);
                                RoutingManager.to(RoutesName.newWeeklyPurchase);
                                // Navigator.of(context).push(
                                //     MaterialPageRoute(
                                //         builder: (context) =>
                                //         const WeekPurchaseScreen()));
                                },
                              title: 'Weekly purchase'.tr,
                            ),
                            // SizedBox(width: 16),
                            // PurchaseScreenButton(onPressed: () {}, title: 'جميع المشتريات'),
                          ],
                        ),
                      ),
                    ],
                  ),
 */






// old code

/*
restaurantController.balance == null
              ? CenterTitleWidget(
            title: 'no_card_found'.tr,
            iconData: Icons.flag,
          )
              : ModalProgressHUD(
            inAsyncCall: false,
            // inAsyncCall: purchaseNotifier.isLoading,
            child: SafeArea(
              child: Stack(
                children: [
                  Positioned(
                    bottom: 0,
                    right: 0,
                    left: 0,
                    child: SvgPicture.asset('assets/svgs/money_bg.svg'),
                  ),
                  Column(
                    children: [
                      //   ScreenHeaderWidget(
                      //     color: AppColors.primeColor,
                      //     titleString: DateFormat('EEEE')
                      //         .format(purchaseNotifier.date), //dateFormatDay,
                      //     actionWidget: Column(
                      //       children: [
                      //         Text(
                      //           'balance'.tr.toUpperCase(),
                      //           style: const TextStyle(
                      //             color: Colors.white,
                      //             fontWeight: FontWeight.bold,
                      //             fontSize: 16,
                      //             height: 2,
                      //           ),
                      //         ),
                      //         const SizedBox(height: 4),
                      //         Text(
                      //           restaurantController.balance
                      //                   .toString()
                      //               ,
                      //           style: const TextStyle(
                      //             color: Colors.white,
                      //             fontWeight: FontWeight.bold,
                      //             fontSize: 18,
                      //             height: 1.2,
                      //           ),
                      //         ),
                      //       ],
                      //     ),
                      //     expansionWidget: InkWell(
                      //       onTap: () {
                      //         showDialog(
                      //           context: context,
                      //           builder: (context) {
                      //             return Padding(
                      //               padding:
                      //                   const EdgeInsets.symmetric(vertical: 100),
                      //               child: Dialog(
                      //                 shape: RoundedRectangleBorder(
                      //                   borderRadius:
                      //                       BorderRadius.circular(12),
                      //                 ),
                      //                 backgroundColor: Colors.white,
                      //                 child: CustomTableCalendarWidget(
                      //                   onDayChanged: (DateTime selectedDay) async {
                      //                     setState(
                      //                       () {
                      //                         _selectedDay = selectedDay;
                      //                       },
                      //                     );
                      //                     await purchaseNotifier.getThisDayPurchase(
                      //                       childId: int.parse(authController
                      // .childrens[homeController.selectedChild.value].id),
                      //                       date: _selectedDay,
                      //                     );
                      //                     Navigator.of(context).pop();
                      //                   },
                      //                 ),
                      //               ),
                      //             );
                      //           },
                      //         );
                      //       },
                      //       child: Text(
                      //         date,
                      //         maxLines: 1,
                      //         overflow: TextOverflow.ellipsis,
                      //         style: const TextStyle(
                      //           color: Colors.white,
                      //           fontWeight: FontWeight.bold,
                      //           fontSize: 18,
                      //         ),
                      //       ),
                      //     ),
                      //   ),
                      const SizedBox(height: 16),
                      Container(
                        height: MediaQuery.of(context).size.height * 0.5,
                        width: MediaQuery.of(context).size.width * 0.8,
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          color: const Color(0xffD4B5B3),//AppColors.primeColor.withOpacity(0.9),
                          boxShadow: [
                            BoxShadow(
                              color: Colors.grey.withAlpha(150),
                              blurRadius: 10,
                              spreadRadius: 0.1,
                              offset: const Offset(0, 5),
                            ),
                          ],
                        ),
                        child: ClipRRect(
                          borderRadius: BorderRadius.circular(15),
                          child: purchaseNotifier.thisDayPurchase.isNotEmpty
                              ? ListView.builder(
                            itemCount: purchaseNotifier
                                .thisDayPurchase.length,
                            itemBuilder: (context, index) {
                              log('${purchaseNotifier.thisDayPurchase.length}');
                              return PurchaseListItem(
                                purchaseItem: purchaseNotifier
                                    .thisDayPurchase[index],
                              );
                              },
                          )
                              : Center(child: Text('purchase_empty'.tr)),
                        ),
                      ),
                      const SizedBox(height: 32),
                      Container(
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(15),
                          // color: AppColors.primeColor,
                            gradient: const LinearGradient(
                                begin: Alignment.centerRight,
                                end: Alignment.topRight,
                                colors: [
                                  Color.fromRGBO(232, 211, 211, 1),
                                  Color.fromRGBO(217, 217, 217, 1),
                                ]
                            )
                        ),
                        padding: const EdgeInsets.symmetric(
                            horizontal: 16, vertical: 8),
                        child: Column(
                          children: [
                            Text(
                              'Total payment'.tr,
                              style: TextStyle(
                                color: AppColors.newPrimeColor,//Colors.white,
                                fontSize: 14,
                                height: 1.2,
                                fontFamily: AppFonts.alatsi
                              ),
                            ),
                            const SizedBox(
                              height: 5,
                            ),
                            Text(
                              purchaseNotifier.thisDayTotalAmount
                                  .toString(),
                              style: TextStyle(
                                color: AppColors.newPrimeColor,//Colors.white,
                                fontWeight: FontWeight.bold,
                                fontSize: 18,
                                height: 1.2,
                                fontFamily: AppFonts.alatsi
                              ),
                            ),
                          ],
                        ),
                      ),
                      Padding(
                        padding: const EdgeInsets.all(16.0),
                        child: Row(
                          children: [
                            PurchaseScreenButton(
                                onPressed: () {
                                  Navigator.of(context).push(
                                      MaterialPageRoute(
                                          builder: (context) =>
                                          const SetDailyLimitScreen()));
                                  },
                                title: 'settings'.tr),
                            const SizedBox(width: 16),
                            PurchaseScreenButton(
                              onPressed: () async{
                                await newPurchaseController.getPurchaseTable(authController.childrens[homeController.selectedChild.value].id);
                                RoutingManager.to(RoutesName.newWeeklyPurchase);
                                // Navigator.of(context).push(
                                //     MaterialPageRoute(
                                //         builder: (context) =>
                                //         const WeekPurchaseScreen()));
                                },
                              title: 'Weekly purchase'.tr,
                            ),
                            // SizedBox(width: 16),
                            // PurchaseScreenButton(onPressed: () {}, title: 'جميع المشتريات'),
                          ],
                        ),
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
 */