import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/constant/font.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/home/presentation/screens/home_page.dart';
import '../../../../../../features/restaurant/business_logic/restaurant_controller.dart';
import '../../../../../../features/purchase/purchase_notifier.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class SetDailyLimitScreen extends StatefulWidget {
  const SetDailyLimitScreen({Key? key}) : super(key: key);

  @override
  _SetDailyLimitScreenState createState() => _SetDailyLimitScreenState();
}

class _SetDailyLimitScreenState extends State<SetDailyLimitScreen> {

  final RestaurantController restaurantController =
  Get.find<RestaurantController>();
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();
  final PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());


  late int daily_limit;
  late int balance;
  int tempDailyLimit = 0;
  bool isLoading = true;

  LoadData() async{
    restaurantController.setRegistrationRecord(
      authController.childrens[homeController.selectedChild.value].id,
    );
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) async {
      restaurantController.setRegistrationRecord(
        authController.childrens[homeController.selectedChild.value].id,
      );
      await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
      await restaurantController.getStudentDailyLimit();
      await purchaseNotifier.getStudentDailyLimit(
          authController.childrens[homeController.selectedChild.value].id);
      purchaseNotifier.resetTempDailyLimit();
      setState(() {
        tempDailyLimit = purchaseNotifier.tempDailyLimit;
        isLoading = false;
      });
    });

  }

  @override
  void initState() {
    super.initState();
    LoadData();
    setState(() {
      tempDailyLimit = purchaseNotifier.tempDailyLimit;
    });
  }


  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          title: Padding(
            padding: EdgeInsets.symmetric(horizontal: Get.width * .25),
            child: HeadTitleText(
                'settings'.tr,
              size: 20,
              color: AppColors.newPrimeColor,
              fontFamily: AppFonts.alatsi,
            ),
          ),
          leading: Icon(
            Icons.arrow_back,
            color: AppColors.newPrimeColor,
            size: 35,
          ).onTap((){
            Navigator.of(context).pop();
          }),
          // leadingWidth: 20,
        ),
        body: SafeArea(
          child: Stack(
            children: [
              // Positioned(
              //   bottom: 0,
              //   right: 0,
              //   left: 0,
              //   child: SvgPicture.asset('assets/svgs/money_bg.svg'),
              // ),
              Column(
                children: [
                  // ScreenHeaderWidget(
                  //   color: AppColors.secondaryColor,
                  //   titleString: 'settings'.tr,
                  // ),
                  Card(
                    margin: const EdgeInsets.all(32),
                    shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(25)),
                    child: SizedBox(
                      width: double.infinity,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          HeadTitleText(
                            'full balance'.tr.capitalize ?? '',
                            size: 22,
                            color: AppColors.newPrimeColor,
                            fontFamily: AppFonts.alatsi,
                          ),
                          // Text(
                          //   'full balance'.tr.capitalize ?? '',
                          //   style: TextStyle(
                          //     fontSize: 22,
                          //     color: AppColors.primeColor,
                          //   ),
                          // ),
                          HeadTitleText(
                            restaurantController.balance.toString(),
                            size: 22, color: AppColors.newPrimeColor,
                            fontFamily: AppFonts.alatsi,
                          ),
                          // Text(
                          //   restaurantController.balance.toString(),
                          //   style: TextStyle(
                          //     fontSize: 22,
                          //     color: AppColors.primeColor,
                          //   ),
                          // ),
                        ],
                      ),
                    ),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.center,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      InkWell(
                        onTap: () {
                          setState(() {
                            if(tempDailyLimit != 0){
                              tempDailyLimit -= 500 ;
                            }
                            else null;
                            // purchaseNotifier.tempDailyLimit -= 500;
                          });
                          // purchaseNotifier.minusToTempDailyLimit();
                          // Navigator.pushReplacement(
                          //   context,
                          //   MaterialPageRoute(
                          //       builder: (BuildContext context) =>
                          //           const SetDailyLimitScreen()),
                          // );
                        },
                        child: Card(
                          shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(25)),
                          color: AppColors.primeColor,
                          child: const Padding(
                            padding: EdgeInsets.all(8.0),
                            child: SizedBox(
                              height: 40,
                              width: 40,
                              child: Center(
                                child: Text('-',
                                    style: TextStyle(
                                        color: Colors.white,
                                        fontSize: 40,
                                        height: 1.0)),
                              ),
                            ),
                          ),
                        ),
                      ),
                      Card(
                        color: AppColors.primeColor,
                        margin: const EdgeInsets.all(32),
                        shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(25)),
                        child: SizedBox(
                          width: MediaQuery.of(context).size.width * 0.3,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            mainAxisSize: MainAxisSize.min,
                            children: [
                              Padding(
                                padding: const EdgeInsets.all(8.0),
                                child:
                                Text(
                                  'daily limit'.tr.capitalize ?? '',
                                  textAlign: TextAlign.center,
                                  style: const TextStyle(
                                    fontSize: 22,
                                    height: 1.4,
                                    color: Colors.white,
                                  ),
                                ),
                              ),
                              isLoading == true
                                  ? CircularProgressIndicator(
                                backgroundColor: AppColors.quizShadow,
                                color: Colors.white,
                              )
                                  : Text(
                                tempDailyLimit.toString(),//purchaseNotifier.tempDailyLimit.toString(),
                                style: const TextStyle(
                                  fontSize: 22,
                                  color: Colors.white,
                                ),
                              ),
                            ],
                          ),
                        ),
                      ),
                      InkWell(
                        onTap: () {
                          setState(() {
                            tempDailyLimit += 500 ;
                          });
                          // purchaseNotifier.addToTempDailyLimit();
                          // Navigator.pushReplacement(
                          //   context,
                          //   MaterialPageRoute(
                          //       builder: (BuildContext context) =>
                          //           const SetDailyLimitScreen()),
                          // );
                        },
                        child: Card(
                          shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(25)),
                          color: AppColors.primeColor,
                          child: const Padding(
                            padding: EdgeInsets.all(8.0),
                            child: SizedBox(
                              height: 40,
                              width: 40,
                              child: Center(
                                child: Text(
                                  '+',
                                  style: TextStyle(
                                    color: Colors.white,
                                    fontSize: 40,
                                    height: 1.0,
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                  const Expanded(child: SizedBox()),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceAround,
                    children: [
                      MaterialButton(
                        onPressed: () {
                          Navigator.of(context).pop();
                        },
                        textColor: AppColors.primeColor,
                        shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(15)),
                        color: Colors.white,
                        child: Text('back'.tr),
                      ),
                      MaterialButton(
                        onPressed: () {
                          purchaseNotifier.updateDailyLimit(
                              childId: int.parse(authController
                                  .childrens[homeController.selectedChild.value]
                                  .id),
                            newDailyLimit1: tempDailyLimit
                          );
                          Navigator.pushReplacement(
                            context,
                            MaterialPageRoute(
                                builder: (BuildContext context) =>
                                     HomePageScreen()),
                          );
                        },
                        textColor: Colors.white,
                        shape: RoundedRectangleBorder(
                            borderRadius: BorderRadius.circular(15)),
                        color: AppColors.primeColor,
                        child: Text('save'.tr),
                      ),
                    ],
                  ),
                  const SizedBox(height: 64),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
