import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../core/routing/routing_manager.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/purchase/models/day_purchase_model.dart';
import '../../../../../../features/purchase/models/purchase_item_model.dart';
import '../../../../../../features/purchase/purchase_notifier.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:modal_progress_hud_nsn/modal_progress_hud_nsn.dart';

import '../../../common/constant/font.dart';

class WeekPurchaseScreen extends StatefulWidget {
  const WeekPurchaseScreen({Key? key}) : super(key: key);

  @override
  _WeekPurchaseScreenState createState() => _WeekPurchaseScreenState();
}

class _WeekPurchaseScreenState extends State<WeekPurchaseScreen> {
  final AuthController authController = Get.find<AuthController>();
  final HomeController homeController = Get.find<HomeController>();
  bool isLoad = true;


  @override
  void initState() {
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      // RegistrationNotifier registrationNotifier =  Get.put(RegistrationNotifier());
      final AuthController authController = Get.find<AuthController>();
      final HomeController homeController = Get.find<HomeController>();
      // PurchaseNotifier purchaseNotifier = Get.put(PurchaseNotifier());
      purchaseNotifier.getWeekPurchase(
          childId: int.parse(
              authController.childrens[homeController.selectedChild.value].id));
    });
  }

  PurchaseNotifier purchaseNotifier = Get.find<PurchaseNotifier>();

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          title: Center(
            child: HeadTitleText(
              'Weekly purchase'.tr.capitalize ?? '',
              size: 24,
              color: AppColors.newPrimeColor,
              fontFamily: AppFonts.alatsi,
            ),
          ),
          leading: Icon(
            Icons.arrow_back,
            size: 35,
            color: AppColors.newPrimeColor,
          ).onTap((){
            RoutingManager.to(RoutesName.food);
          })
        ),
        body: purchaseNotifier.isLoading
            ? CircularProgressIndicator(
          backgroundColor: AppColors.quizShadow,
          color: AppColors.newPrimeColor,
        )
        : ModalProgressHUD(
          inAsyncCall: purchaseNotifier.isLoading,
          child: SizedBox(
            height: MediaQuery.of(context).size.height,
            child: SafeArea(
              child: Stack(
                children: [
                  Positioned(
                    bottom: 0,
                    right: 0,
                    left: 0,
                    child: SvgPicture.asset('assets/svgs/money_bg.svg'),
                  ),
                  SingleChildScrollView(
                    child: Column(
                      mainAxisSize: MainAxisSize.max,
                      children: [
                        // ScreenHeaderWidget(
                        //   color: AppColors.primeColor,
                        //   titleString: 'Weekly purchase'.tr.capitalize ?? '',
                        // ),
                        for (DayPurchaseModel p
                            in purchaseNotifier.weekPurchaseList)
                          Card(
                            shape: RoundedRectangleBorder(
                                borderRadius: BorderRadius.circular(25)),
                            clipBehavior: Clip.hardEdge,
                            margin: const EdgeInsets.only(
                                top: 16, left: 16, right: 16),
                            color: Colors.white,
                            child: ExpansionTile(
                              title: Text(p.day,
                                  style: TextStyle(color: AppColors.primeColor)),
                              trailing: Text(
                                getTotalAmountOfDay(purchaseList: p.history)
                                    .toString(),
                                style: const TextStyle(color: Colors.black87),
                              ),
                              children: [
                                p.history.isEmpty
                                    ? Center(
                                        child:
                                            Text('purshase_empty_in_this_day'.tr),
                                      )
                                    : Container(),
                                for (PurchaseItem item in p.history)
                                  Padding(
                                    padding: const EdgeInsets.symmetric(
                                        horizontal: 16),
                                    child: Row(
                                      children: [
                                        Column(
                                          children: [
                                            Padding(
                                              padding: const EdgeInsets.all(8.0),
                                              child: Chip(
                                                label: Text(
                                                  item.type == "buy"
                                                      ? "شراء"
                                                      : "إرجاع",
                                                  style: const TextStyle(
                                                      color: Colors.white,
                                                      fontSize: 10),
                                                ),
                                                backgroundColor:
                                                    item.type == "buy"
                                                        ? Colors.green
                                                        : AppColors.primeColor,
                                              ),
                                            ),
                                          ],
                                        ),
                                        Expanded(
                                          child: Stack(
                                            children: [
                                              Padding(
                                                padding: const EdgeInsets.only(
                                                    right: 50),
                                                child: Wrap(
                                                  children: [
                                                    Align(
                                                      alignment:
                                                          Alignment.centerLeft,
                                                      child: Text(
                                                          '${item.product}  x ${item.quantity} = ${item.totalAmount}'),
                                                    ),
                                                  ],
                                                ),
                                              ),
                                              Positioned(
                                                right: 0,
                                                child: Text(DateFormat('hh:mm')
                                                    .format(item.date)),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),
                                const SizedBox(height: 16),
                              ],
                            ),
                          ),
                        const SizedBox(height: 32),
                        SizedBox(
                          height: 38,
                          width: Get.width * .3,
                          child: ClipRRect(
                            borderRadius: BorderRadius.circular(15),
                            child: ElevatedButton(
                              style: ElevatedButton.styleFrom(
                                backgroundColor: AppColors.newPrimeColor,
                                // Background color
                              ),
                              onPressed: () {
                                Navigator.of(context).pop();
                              },
                              child: HeadTitleText(
                                'back'.tr,
                                size: 20,
                                color: Colors.white,
                                fontFamily: AppFonts.alatsi,
                              )
                            ),
                          ),
                        ),
                        const SizedBox(height: 32),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }
}

num getTotalAmountOfDay({required List<PurchaseItem> purchaseList}) {
  num total = 0;

  for (PurchaseItem item in purchaseList) {
    if (item.type == "buy") {
      total += item.totalAmount;
    } else {
      total -= item.totalAmount;
    }
  }

  return total;
}



/*
Text(
                                'back'.tr,
                                style: TextStyle(
                                  color: Colors.white,
                                  fontWeight: FontWeight.bold,
                                ),
                              ),
 */