import '../../../../../../common/constant/colors.dart';
import '../../../../../../features/purchase/models/purchase_item_model.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

class PurchaseListItem extends StatelessWidget {
  const PurchaseListItem({Key? key, required this.purchaseItem})
      : super(key: key);

  final PurchaseItem purchaseItem;

  @override
  Widget build(BuildContext context) {
    var dateFormatTime = DateFormat('kk:mm:a').format(purchaseItem.date);

    return Padding(
      padding: const EdgeInsets.only(bottom: 1),
      child: Container(
        color: AppColors.secondaryColor.withOpacity(0.5),
        child: Padding(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 8),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    '${purchaseItem.totalAmount} IQD',
                    style: const TextStyle(
                      color: Colors.white,
                      fontWeight: FontWeight.bold,
                      fontSize: 14,
                      height: 1.2,
                    ),
                  ),
                  Text(
                    '${purchaseItem.product} x${purchaseItem.quantity}',
                    style: const TextStyle(
                      color: Colors.white,
                      fontWeight: FontWeight.bold,
                      fontSize: 14,
                      height: 1.2,
                    ),
                  ),
                ],
              ),
              Column(
                children: [
                  Chip(
                    label: Text(
                      purchaseItem.type == "buy" ? "شراء" : "إرجاع",
                      style: const TextStyle(color: Colors.white, fontSize: 10),
                    ),
                    backgroundColor: purchaseItem.type == "buy"
                        ? Colors.green
                        : AppColors.primeColor,
                  ),
                  Text(
                    dateFormatTime,
                    style: const TextStyle(
                      fontSize: 13,
                      height: 1.2,
                      color: Colors.white,
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
