import '../../../../../../common/constant/colors.dart';
import 'package:flutter/material.dart';

import '../../../common/constant/font.dart';

class PurchaseScreenButton extends StatelessWidget {
  final VoidCallback onPressed;
  final String title;

  const PurchaseScreenButton({Key? key, required this.onPressed, required this.title}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Expanded(
      child: MaterialButton(
        onPressed: onPressed,
        color: AppColors.secondaryColor,
        // textColor: Colors.white,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(15),
        ),
        child: Text(
            title,
          style: TextStyle(
            fontFamily: AppFonts.alatsi,
            fontWeight: FontWeight.normal,
            color: Colors.white,
            fontSize: 18
          ),
        ),//HeadTitleText(
      //   title,
      //   fontFamily: AppFonts.alatsi,
      //   color: Colors.white,
      // ),//
      ),
    );
  }
}
