import 'dart:developer';
import 'package:flutter/animation.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../core/local%20storage/local_storage.dart';
import '../../../../../../features/purchase/models/buffet_card_model.dart';
import '../../../../../../features/restaurant/data/entities/match.dart';
import '../../../../../../features/restaurant/data/entities/resturant_meal_entity.dart';
import '../../../../../../features/restaurant/data/model/get_meals.dart';
import '../../../../../../features/restaurant/data/model/meal_request.dart' ;
import '../../../../../../features/restaurant/data/source/restaurant_web.dart';
import '../../../common/widgets/snack_bar_widget.dart';
import '../data/model/meal.dart';
import '../data/model/meals_model.dart';
import '../data/source/meals_service.dart';

class RestaurantController extends GetxController {
  int balance = 0;
  int daily_limit = 0;
  bool loading = false;
  // ------------- Data Sources -------------

  RestaurantWebService restaurantRepo = RestaurantWebService();

  // ------------- Rx Variables -------------

  GetMealsEntity getMealsRequestModel = GetMealsEntity.zero();

  RxFuture<List<StudentMeal>> getMealsResponseModel = RxFuture(<StudentMeal>[]);
  RxFuture<BuffetCardModel> getBuffetResponseModel = RxFuture(BuffetCardModel(dailyLimit: 0, balance: 0));

  RxFuture<int> getBalanceNew = RxFuture(0);

  // ------------- Setters -------------

  void setRegistrationRecord(String registrationRecordId) {
    getMealsRequestModel.registrationRecordId = registrationRecordId;
    log('sssssssssssssss : ${getMealsRequestModel.registrationRecordId}');
    log('BBBBBBBBBBBBBBB: $registrationRecordId');
  }

  // ------------- Methods -------------
  Match match = Match.zero();

  Future<void> getStudentMeals() async {
    getMealsResponseModel.observe(
      (_) async {
        return await restaurantRepo.getStudentMeals(
          registrationRecordId: getMealsRequestModel.registrationRecordId,
          dateFrom: getMealsRequestModel.dateFrom,
          dateTo: getMealsRequestModel.dateTo,
        );
      },
      onSuccess: (p0) {
        fillListOfMeals();
      },
      onError: (error) {
         snackBarWidget('Error', 'something wrong');
      },
    );
  }

  Future<void> getStudentBalance(String registrationRecordId) async {
    loading = true;
    await getBalanceNew.observe(
        (_) async{
          balance = await restaurantRepo.getStudentBalance(
            registrationRecordId: registrationRecordId,//getMealsRequestModel.registrationRecordId,
          );
          return balance;
        },
      onError: (e){
        snackBarWidget("Ooop's somthing wrong", "student do not have buffet card");
      }
    );
    // balance = await restaurantRepo.getStudentBalance(
    //       registrationRecordId: getMealsRequestModel.registrationRecordId,
    //     );
    loading = false;
  }

  Future<void> getStudentDailyLimit() async {
    loading = true;
    daily_limit = await restaurantRepo.getStudentDailyLimet(
          registrationRecordId: getMealsRequestModel.registrationRecordId,
        );
    loading = false; 
  }


  List<String> date = [];
  List<StudentMeal> studentMeals = [];
  void fillListOfMeals() {
    for (int i = 0; i < match.week.length; i++) {
      date.add(DateFormat('yyyy-MM-dd').format(match.week[i]));

      //  print(date);
    }
    for (int i = 1; i < 6; i++) {
      studentMeals.add(StudentMeal.zero(date[i], 'not selected yet'));
    }
    if (getMealsResponseModel.result.isNotEmpty) {
      for (int i = 0; i < getMealsResponseModel.result.length; i++) {
        for (int j = 0; j < studentMeals.length; j++) {
          if (getMealsResponseModel.result[i].date == studentMeals[j].date) {
            studentMeals.removeAt(j);
          }
        }
        getMealsResponseModel.result[i].meal.check = true;
        studentMeals.insert(i, getMealsResponseModel.result[i]);
      }
      studentMeals.sort((a, b) {
        return DateTime.parse(a.date).compareTo(DateTime.parse(b.date));
      });
      //  print(studentMeals);
    }
  }

  RxFuture<List<MealElement>> state = RxFuture(<MealElement>[]);
  MealsService mealsService = MealsService();

  // Future<void> getMeals() async {
  //   await state.observe((value) async {
  //     return await mealsService.getMeals();
  //   });
  // }

  MealElement mealElement = MealElement.zero();
  List<bool> isSelectedList = [];
  List<MealsArray> meals = [];
  void onChangeColor(int index, MealModel mealModel, String date) {
    isSelectedList[index] = !isSelectedList[index];
    mealElement.isChecked = !mealElement.isChecked;
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // mealRequest.removeWhere((element) => element.date == date);

    // mealRequest.add(MealRequest(
    //     registration_record_id: getMealsRequestModel.registrationRecordId,
    //     meal_id: mealModel.id,
    //     date: date,
    //     quantity: 1));
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///
      
    if(meals.any((element) => element.meal_id == mealModel.id)){
      // print("object");
      // print(mealModel.id);
      // print("object");
      meals.removeWhere((element) => element.meal_id == mealModel.id);  
    }
    else{
    meals.add(MealsArray(mealModel.id, 1));
    }

    mealRequest.removeWhere((element) => element.date == date);

    mealRequest.add(MealRequest(
        registration_record_id: getMealsRequestModel.registrationRecordId,
        meals: meals,
        date: date,
      ));
  
  
    getMealsState.update((val) {
      for (int i = 0; i < getMealsState.result.day.length; i++) {
        //  print(mealRequest.date);
        for (int j = 0; j < getMealsState.result.day[i].meals.length; j++) {
          if (val!.value.day[i].day.toLowerCase() == mealModel.day.toLowerCase() &&
              val.value.day[i].meals[index].id == mealModel.id) {
           // val.value.day[i].meals[j].selected = false;
           
           // print(mealModel.name);
           if(val.value.day[i].meals[index].selected  == true)
            {
              // print('Selected = false');
              // print(mealModel.description);
              val.value.day[i].meals[index].selected = false;
            }
            else 
            {
              // print('Selected = true');
              // print(mealModel.price);
              val.value.day[i].meals[index].selected = true;}
              break;
          }
        }
      }
     
    });
    //   for (int i = 0; i < getMealsOfDay.length; i++) {
    //   getMealsOfDay[i].selected = false;
    // }
    // getMealsOfDay[index].selected = true;
  }

   bool isSelected(int index) {
  if (index >= 0 && index < isSelectedList.length) {
    return isSelectedList[index];
  } else {
    // Handle the out-of-range index here, such as returning a default value or throwing an exception.
    throw RangeError('Invalid index: $index');
  }
}
  @override
  void onInit() {
    super.onInit();
    isSelectedList = List.generate(50, (_) => false);
  }

  LocalStorage storage = LocalStorage();
  Future<void> addTokenFromLocalStorage() async {
    String? token = storage.userToken;
    // print("YYYYYYYYYYYYYYYYYYYYYyy");
    print(token);
  }

  RxFuture<MealDays> getMealsState = RxFuture(MealDays.zero());

  List<MealModel> getMealsOfDay = [];

  Future<void> getMeals({String? day}) async {


    await getMealsState.observe(
      (p0) async {
        return await restaurantRepo.getMeals(
            registrationRecordId: getMealsRequestModel.registrationRecordId,
            dateFrom: getMealsRequestModel.dateFrom,
            dateTo: getMealsRequestModel.dateTo);
      },
      onSuccess: (p0)  {
        print("Get Meals Kinan");
        if (day != null) {
          print(day);
          print(getMealsState.result.day[0]);
            meals.clear();
          int ind = 0;
           if( day == "Sunday"){
         ind = 0;
        
        }
        if( day == "Monday"){
          ind = 1;
        
        }
        if( day == "Tuesday"){
          ind = 2;
         
        }
        if(day == "Wednesday"){
          ind = 3;
          
        }
        if( day == "Thursday"){
          ind = 4;
        }
         if( day == "Friday"){
         ind = 5;
        
        }
         if( day == "Saturday"){
         ind = 6;
        
        }
           for (int j = 0; j < getMealsState.result.day[ind].meals.length; j++){
            if(getMealsState.result.day[ind].meals[j].selected==true){
              meals.add(MealsArray(getMealsState.result.day[ind].meals[j].id,1));
              // print("object");
            }
          }

           //   getMealsOfDay =  getMealsState.result.getMeals(day);
              // print(getMealsOfDay[0]);
              // print("  Kinan");

          // for (int j = 0; j < getMealsOfDay.length; j++){
          //   if(getMealsOfDay[j].selected==true){
          //     meals.add(Mealsarray(getMealsOfDay[j].id,1));
          //     print("object");
          //   }
          // }
        // for(int i=0;i<getMealsState.result.day.length;i++){
        //   for (int j = 0; j < getMealsState.result.day[day].meals.length; j++){
        //     if(getMealsState.result.day[i].meals[j].selected==true){
        //       meals.add(Mealsarray(getMealsState.result.day[i].meals[j].id,1));
        //       print("object");
        //     }
        //   }
        // }

    }
        // print("QQQQQRRRRRRRRRRRRRRR");
        // getMeal();
      },
      onError: (error) {
        snackBarWidget('something wrong', error.toString());
      },
    );
  }

   RxFuture<MealDays> getAllMealsState = RxFuture(MealDays.zero());

  List<MealModel> getAllMealsOfDay = [];

  Future<void> getAllMeals({String? day}) async {
    await getAllMealsState.observe(
      (p0) async {
        return await restaurantRepo.getAllMeals(
            day: day.toString());
      },
      onSuccess: (p0) {
        if (day != null) {
          getAllMealsOfDay = getAllMealsState.result.getAllMeals(day);
        }
        // print("QQQQQRRRRRRRRRRRRRRR");
        // getMeal();
      },
      onError: (error) {
        snackBarWidget('something wrong', error.toString());
      },
    );
  }

 

  List<MealModel> getMeal(String day, int index) {
    return getMealsState.result.day[index].meals;
  }

  List<MealRequest> mealRequest = [];
  RxFuture<void> sendMealState = RxFuture(null);
  Future<void> sendMeal({VoidCallback? onSuccess}) async {
    await sendMealState.observe((_) async {
      for (int i = 0; i < mealRequest.length; i++) {
        // print(mealRequest);
        // print("ooooooooo");
        // print(i);
        // print(mealRequest[i]);
        await restaurantRepo.sendMeal(mealRequest[i]);
      }
    }, onSuccess: (p0) {
      //  studentMeals.clear();
      onSuccess!.call();
      date.clear();
      meals.clear();
    }, onError: (e) {
      if (e.toString() == 'Unknown Error') {
        snackBarWidget('', 'Can\'t edit now');
      } else {
        snackBarWidget('', e.toString());
      }
    });
  }
}
