class MealDays {
  String status;
  List<DailyMeal> day;

  MealDays({required this.day, required this.status});

  factory MealDays.fromJson(Map<String, dynamic> json) {
    List<DailyMeal> dailyMeals = [];
    json["meals"].forEach((key, value) {
      dailyMeals.add(DailyMeal(day: key, meals: MealModel.fromJsonList(value)));
    });
    return MealDays(status: json["status"] ?? "", day: dailyMeals);
  }

  factory MealDays.zero() => MealDays(day: [], status: '');

  List<MealModel> getMeals(String dayVal) {
    DailyMeal dailyMeal = day.firstWhere(
      (dayElement) => dayElement.day == dayVal,
    );
    return dailyMeal.meals;
  }
   List<MealModel> getAllMeals(String dayVal) {
    DailyMeal dailyMeal = day.firstWhere(
      (dayElement) => dayElement.day == dayVal,
    );
    return dailyMeal.meals;
  }
}

class DailyMeal {
  String day;
  List<MealModel> meals;

  DailyMeal({required this.day, required this.meals});

  factory DailyMeal.zero() => DailyMeal(day: '', meals: []);
}

class MealModel {
  MealModel({
    required this.id,
    required this.name,
    required this.image,
    required this.description,
    required this.status,
    required this.price,
    required this.day,
    required this.selected,
  });

  int id;
  String name;
  String image;
  String description;
  String status;
  int price;
  String day;
  bool selected;

  factory MealModel.fromJson(Map<String, dynamic> json) => MealModel(
        id: json["id"],
        name: json["name"],
        image: json["image"],
        description: json["description"],
        status: json["status"],
        price: json["price"],
        day: json["day"],
        selected: json["selected"],
      );
  static List<MealModel> fromJsonList(List<dynamic>? json) {
    List<MealModel> meals = [];
    if (json == null) {
      return [];
    }
    try {
      for (var meal in json) {
        meals.add(MealModel.fromJson(meal));
      }
    } catch (e) {
      print(e.toString());
    }
    return meals;
  }

  Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
        "image": image,
        "description": description,
        // "status": statusValues.reverse[status],
        "price": price,
        // "day": dayEnumValues.reverse[day],
        "selected": selected,
      };
  // factory MealModel.zero() => MealModel(
  //     id: 0,
  //     name: '',
  //     image: '',
  //     description: '',
  //     status: '',
  //     price: 0,
  //     day: '',
  //     selected: false);
}
