class Meals {
  Meals({
    required this.meals,
  });

  List<MealElement> meals;

  factory Meals.fromJson(Map<String, dynamic> json) => Meals(
        meals: List<MealElement>.from(
            json["meals"].map((x) => MealElement.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "meals": List<dynamic>.from(meals.map((x) => x.toJson())),
      };
}

class MealElement {
  MealElement(
      {required this.id,
      required this.day,
      required this.date,
      required this.image,
      required this.name,
      required this.isChecked});

  String id;
  String day;
  String date;
  String image;
  String name;
  bool isChecked;

  factory MealElement.fromJson(Map<String, dynamic> json) => MealElement(
      id: json["id"],
      day: json["day"],
      date: json["date"],
      image: json["image"],
      name: json["name"],
      isChecked: json["isChecked"]);

  Map<String, dynamic> toJson() => {
        "id": id,
        "day": day,
        "date": date,
        "image": image,
        "name": name,
        "isChecked": isChecked
      };
  factory MealElement.zero() => MealElement(
      id: '', day: '', date: '', image: '', name: '', isChecked: false);
}
