import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/extensions/date.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/restaurant/data/model/meal.dart';
import '../../../../../../features/restaurant/presentation/widgets/show_meal.dart';
import '../../../../common/constant/colors.dart';
import '../../../../common/widgets/snack_bar_widget.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/routing/routing_manager.dart';
import '../../business_logic/restaurant_controller.dart';
import '../widgets/school_button.dart';

class ChangePage extends StatefulWidget {

  ChangePage({super.key} );

  @override
  State<ChangePage> createState() => _ChangePageState();
}

class _ChangePageState extends State<ChangePage> {

  RestaurantController restaurantController = Get.find<RestaurantController>();

  AuthController authController = Get.find<AuthController>();

  HomeController homeController = Get.find<HomeController>();

  StudentMeal dailyMeal = Get.arguments;

  int _index = 0;

  @override
  Widget build(BuildContext context) {
    // restaurantController.getMeals();
    return SafeArea(child: Scaffold(
      body: Obx(() {
        if (DateTime.parse(dailyMeal.date).toDay() == "Sunday") {
          _index = 0;
          print("Sunday");

        }
        if (DateTime.parse(dailyMeal.date).toDay() == "Monday") {
          _index = 1;
          print("Monday");
        }
        if (DateTime.parse(dailyMeal.date).toDay() == "Tuesday") {
          _index = 2;
          print("Tuesday");
        }
        if (DateTime.parse(dailyMeal.date).toDay() == "Wednesday") {
          _index = 3;
          print("Wednesday");
        }
        if (DateTime.parse(dailyMeal.date).toDay() == "Thursday") {
          _index = 4;
          print("Thursday");
        }
        print(restaurantController
            .getMealsState.result.day[_index].meals[0].selected);
        if (DateTime.parse(dailyMeal.date).toDay() == "Friday") {
          _index = 5;
          print("0");
        }
        if (DateTime.parse(dailyMeal.date).toDay() == "Saturday") {
          _index = 6;
          print("0");
        }
        if (restaurantController.getMealsState.loading) {
          return const CircularProgressIndicatorWidget();
        } else {
          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            mainAxisAlignment: MainAxisAlignment.start,
            children: [
              Row(
                children: [
                  HeadTitleText(
                    DateTime.parse(dailyMeal.date).toDay().tr,
                    color: AppColors.secondaryColor,
                  )
                      .padding(padding: const EdgeInsets.only(left: 10))
                      .expanded(2),
                  NormalText(dailyMeal.date.tr,
                          textColor: AppColors.secondaryColor.withOpacity(0.5))
                      .expanded(2),
                  Divider(
                          thickness: 1.5,
                          color: AppColors.secondaryColor.withOpacity(0.5))
                      .expanded(3)
                ],
              ).paddingSymmetric(horizontal: 10).expanded(1),
              ShowMeal(
                mealsModel:
                    restaurantController.getMealsState.result.day[_index].meals,
                date: dailyMeal.date,
              ).expanded(10),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  SchoolButton(() {
                    RoutingManager.back();
                    restaurantController.getMealsOfDay.clear();
                    restaurantController.mealRequest.clear();
                    restaurantController.studentMeals.clear();
                  }, 'Back', AppColors.secondaryColor),
                  const SizedBox(
                    width: 20,
                  ),
                  Obx(() {
                    return SchoolButton(
                      () async {
                        await restaurantController.sendMeal(
                          onSuccess: () async {
                            restaurantController.studentMeals.clear();
                            restaurantController.getStudentMeals();
                            await restaurantController.getStudentBalance(authController.childrens[homeController.selectedChild.value].id);
                            RoutingManager.back();
                            snackBarWidget('', 'Added successfully');
                            restaurantController.mealRequest.clear();
                            restaurantController.getMealsOfDay.clear();
                            restaurantController.studentMeals.clear();
                          },
                        );
                      },
                      'Save'.tr,
                      AppColors.primeColor.withOpacity(0.8),
                      isLoading: restaurantController.sendMealState.loading,
                    );
                  })
                ],
              ).expanded(1)
            ],
          );
        }
      }),
    ));
  }
}
