import 'dart:convert';
import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:http/http.dart' as http;
import 'package:intl/intl.dart';
import 'package:provider/provider.dart';
import 'package:quickalert/quickalert.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/home/common/changeIndexNotifier.dart';
import '../../../../../../features/restaurant/business_logic/restaurant_controller.dart';
import '../../../../../../helpers/date_helpers.dart';
import '../../../../core/local storage/local_storage.dart';
import '../../../../core/network/api.dart';
import '../../data/model/meal_request.dart';

class RestaurantHome extends StatefulWidget {
  const RestaurantHome({super.key});
  @override
  State<RestaurantHome> createState() => _RestaurantHomeState();
}

class _RestaurantHomeState extends State<RestaurantHome> {
  String? typeUser;
  HomeController homeController = Get.find<HomeController>();
  AuthController authController = Get.find<AuthController>();
  final RestaurantController restaurantController = Get.find<RestaurantController>();
  bool? selected;
  bool? isDone;
  bool? isLoad;
  var data;
  var mealInfo;
  List<dynamic> data1 = [];
  var dateSelected;
  int _buttonTab = 0;
  List<String> days = [
    'sun',
    'mon',
    'tue',
    'wed',
    'thu'
  ];
  List<MealsArray> arrayMeals = [];

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _getDayMeal(_buttonTab);
    isDone = false;
    typeUser = LocalStorage().userTypeUser;
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<ChangeIndexNotifier>(
        builder: (context,indexNotifier,child) {
          return SingleChildScrollView(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              // mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                SizedBox(
                  height: Get.height * .068, //90,
                  child: ListView.builder(
                    scrollDirection: Axis.horizontal,
                    itemCount: 5,
                    itemBuilder: (BuildContext context, int index) {
                      return Padding(
                        padding: EdgeInsets.symmetric(horizontal: MediaQuery
                            .of(context)
                            .size
                            .width * 0.03,
                            vertical: MediaQuery
                                .of(context)
                                .size
                                .width * 0.02),
                        child: GestureDetector(
                          onTap: () {
                            setState(() {
                              isLoad = false;
                              _buttonTab = index;
                              arrayMeals.clear();
                            });
                            _getDayMeal(index);
                          },
                          child: Container(
                            height: _buttonTab == index ? Get.height * .1 : Get
                                .height * .2,
                            width: Get.width * .13, //,50,
                            decoration: BoxDecoration(
                                color: _buttonTab == index ? AppColors
                                    .newPrimeColor : Colors.white,
                                borderRadius: BorderRadius.circular(20)
                            ),
                            child: Center(
                              child: HeadTitleText(
                                days[index].tr.toUpperCase(),
                                fontFamily: 'alatsi',
                                size: 20,
                                color: _buttonTab == index
                                    ? Colors.white
                                    : AppColors.newPrimeColor,
                              ),
                            ),
                          ),
                        ),
                      );
                    },),
                ),
                SizedBox(
                  // color: Colors.black,
                  width: Get.width,
                  height: Get.height < 700 ? Get.height * .55 : Get.height * .57 ,
                  child: isLoad == false
                      ? Center(child: CircularProgressIndicator(
                    color: AppColors.newPrimeColor,
                    backgroundColor: AppColors.newSecondaryColor,
                  ),)
                      :
                  GridView.count(
                    childAspectRatio: Get.height < 700 ? 650 / 470 : 1 / 1,
                    crossAxisCount: 2,
                    shrinkWrap: true,
                    children: List.generate(data1.length, (index) {
                      return Padding(
                        padding: const EdgeInsets.all(8.0),
                        child: GestureDetector(
                          onTap: typeUser == 'parent' ? () {
                            setState(() {
                              mealInfo[index]['ordered'] =
                              !mealInfo[index]['ordered'];
                              mealInfo[index]['ordered'] == true
                                  ? arrayMeals.add(
                                  MealsArray(mealInfo[index]['id'], 1))
                                  : arrayMeals.removeWhere((item) =>
                              item.meal_id == mealInfo[index]['id']);
                            });
                          } : null ,
                          child: Container(
                            decoration: BoxDecoration(
                              color: AppColors.quizItem.withOpacity(0.5),
                              // mealInfo[index]['ordered'] == true ? Colors
                              //     .green : AppColors.quizItem.withOpacity(0.5),
                              border: Border(
                                top: BorderSide(color: AppColors.newPrimeColor),
                                bottom: BorderSide(
                                    color: AppColors.newPrimeColor),
                                left: BorderSide(color: AppColors.newPrimeColor),
                                right: BorderSide(color: AppColors.newPrimeColor),
                              ),
                              borderRadius: BorderRadius.circular(20),
                            ),
                            child: Stack(
                              // mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Container(
                                  width: Get.width,
                                  height: Get.height < 700 ? Get.height * .18 : Get.height * .15,
                                  decoration: BoxDecoration(
                                      color: Colors.transparent,
                                      image: DecorationImage(image: NetworkImage(
                                          '${mealInfo[index]['image']}'),
                                          fit: BoxFit.cover),
                                      borderRadius: BorderRadius.only(
                                          topRight: Radius.circular(20),
                                          topLeft: Radius.circular(20))
                                  ),
                                ),
                                Positioned(
                                  bottom: 0,
                                  child: Padding(
                                    padding: const EdgeInsets.symmetric(
                                        horizontal: 0.0),
                                    child: Container(
                                        height: Get.height * .09,
                                        width: Get.width * .43,//.431,
                                        decoration: BoxDecoration(
                                          color: mealInfo[index]['ordered'] ==
                                              true ? Colors.green : Colors
                                              .grey[200],
                                          borderRadius: const BorderRadius.only(
                                            bottomRight: Radius.circular(20),
                                            bottomLeft: Radius.circular(20),
                                            topLeft: Radius.circular(30),
                                            topRight: Radius.circular(30),
                                          ),
                                        ),
                                        child: AutoSizeText(
                                          '${mealInfo[index]['name']}',
                                          maxLines: 2,
                                          minFontSize: 12,
                                          maxFontSize: 20,
                                        ).paddingSymmetric(
                                            vertical: 20, horizontal: 50)
                                    ),
                                  ),
                                ),
                                Positioned(
                                  bottom: 0,
                                  left: 20,
                                  right: 20,
                                  child: Padding(
                                    padding: const EdgeInsets.only(bottom: 8.0),
                                    child: Center(child: Text(
                                        '${mealInfo[index]['price']}'
                                            .toString())),
                                  ),
                                )
                              ],
                            ),
                          ),
                        ),
                      );
                    }),
                  ),
                ),
                SizedBox(height: 20,),

                GestureDetector(
                  onTap: typeUser == 'parent' ? () {
                    // print('on tap array meals -------------------------------');
                    // print(arrayMeals.length);
                    _saveDayMeal(arrayMeals, _buttonTab);
                  } : null ,
                  child: Container(
                    width: MediaQuery
                        .of(context)
                        .size
                        .width / 2,
                    height: MediaQuery
                        .of(context)
                        .size
                        .height * 0.05,
                    decoration: BoxDecoration(
                        color: AppColors.newPrimeColor,
                        borderRadius: BorderRadius.circular(40)
                    ),
                    child: HeadTitleText(
                      'save'.tr.toUpperCase(),
                      color: Colors.white,
                      fontFamily: 'alatsi',
                    ).center(),
                  ),
                ),
                SizedBox(height: 100,)
              ],
            ),
          );
        });
    }


  _getDayMeal(int ind) async {
    var _token = AuthController().token;
    var _regs = authController.childrens[homeController.selectedChild.value].id;//restaurantController.getMealsRequestModel.registrationRecordId;
    var _date ;
    switch(ind){
      case 0:
        _date = DateFormat('d-M-y').format(DateHerlpers.getFullWeek()[1]);
      case 1:
        _date = DateFormat('d-M-y').format(DateHerlpers.getFullWeek()[2]);
      case 2:
        _date = DateFormat('d-M-y').format(DateHerlpers.getFullWeek()[3]);
      case 3:
        _date = DateFormat('d-M-y').format(DateHerlpers.getFullWeek()[4]);
      case 4:
        _date = DateFormat('d-M-y').format(DateHerlpers.getFullWeek()[5]);
    }
    http.Response res = await Api().getData('parent/${authController.childrens[homeController.selectedChild.value].id}/meal/per-day/${_date}');
    var body = json.decode(res.body);
    if(res.statusCode == 200){
      setState(() {
        data = body['meals'];
        mealInfo = data;
        data1 = data;
        isLoad = true;
        for(int i=0;i<data1.length; i++){
          if(data1[i]['ordered'] == true){
            arrayMeals.add(MealsArray(data1[i]['id'], 1));
          }
        }
      });
    }else{
      setState(() {
        isLoad = true;
      });
    }
  }

  _saveDayMeal(List<MealsArray> arrayMeals, int ind) async{
    var _regs = restaurantController.getMealsRequestModel.registrationRecordId;
    var _date;
    switch(ind){
      case 0:
        _date = DateFormat('y-MM-dd').format(DateHerlpers.getFullWeek()[1]);
      case 1:
        _date = DateFormat('y-MM-dd').format(DateHerlpers.getFullWeek()[2]);
      case 2:
        _date = DateFormat('y-MM-dd').format(DateHerlpers.getFullWeek()[3]);
      case 3:
        _date = DateFormat('y-MM-dd').format(DateHerlpers.getFullWeek()[4]);
      case 4:
        _date = DateFormat('y-MM-dd').format(DateHerlpers.getFullWeek()[5]);
    }
    Map<String, dynamic> toJson () {
      return {
      "registration_record_id": _regs,
      "date": _date,
      "meals": arrayMeals.map((meal) => meal.toJson()).toList(),
      };
    }
    http.Response res = await Api().postData(toJson(), 'student_meal/list');
    var body = json.decode(res.body);
    if(res.statusCode == 200){
      snackBarWidget(body['status'], body['data']['message']);
      QuickAlert.show(
        context: context,
        type: QuickAlertType.success,
        text: body['data']['message'],

      );
      await restaurantController.getStudentBalance(_regs);
    }else{
      snackBarWidget(body['status'], body['message']);
      QuickAlert.show(
        context: context,
        type: QuickAlertType.error,
        text: body['message'],
      );
    }
  }

}
