import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../features/restaurant/data/model/get_meals.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/text.dart';

class WeekDayWidget extends StatelessWidget {
  String date;
  DailyMeal mealDays;

//  MealModel mealModel;
  WeekDayWidget({
    super.key,
    required this.mealDays,
    required this.date
  });

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        HeadTitleText(
          mealDays.day.tr,size: 16,
          color: AppColors.secondaryColor,
        ).padding(padding: const EdgeInsets.symmetric(horizontal: 10)).expanded(2),
        NormalText(date.tr,
                textColor: AppColors.secondaryColor.withOpacity(0.5))
            .expanded(2),
        Divider(
                thickness: 1.5,
                color: AppColors.secondaryColor.withOpacity(0.5))
            .expanded(3)
      ],
    );
  }
}
