import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:get/get.dart';
import 'package:package_info_plus/package_info_plus.dart';
import '../../../../../../core/routing/routing_manager.dart';

import '../../../../common/constant/colors.dart';
import '../../../../common/extensions/widget.dart';
import '../../../../common/widgets/app_bar.dart';
import '../../../../common/widgets/text.dart';
import '../../../../core/lang/app_language_controller.dart';
import '../../business_logic/setting_controller.dart';
import '../widgets/drop_down_setting.dart';
import '../widgets/image.dart';
import '../widgets/language_button.dart';

class SettingPage extends StatefulWidget {

  SettingPage({super.key});

  @override
  State<SettingPage> createState() => _SettingPageState();
}

class _SettingPageState extends State<SettingPage> {
  final SettingController settingController = Get.put(SettingController());


  String? version;
  String? buildNumber;

  loadData()async{
    PackageInfo packageInfo = await PackageInfo.fromPlatform();
    setState(() {
      version = packageInfo.version;
      buildNumber = packageInfo.buildNumber;
    });
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    AppLanguageController controllerLang = Get.find();
    String currentLanguageCode = Get.locale.toString();

    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBarWidget(
          title: 'Setting'.tr,
          child: Padding(
            padding: const EdgeInsets.only(bottom: 5),
            child: InkWell(
              child: SvgPicture.asset(
                'asset/icons/LogOut.svg',
                color: AppColors.newPrimeColor
              ),
              onTap: () async {
                await dialog();
                // RoutingManager.offAll(RoutesName.login);
                // await settingController.logout();
              },
            ),
          ),
        ),
        body: SizedBox(
          height: Get.height,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              ProfileImage(),
              Divider(
                color: AppColors.secondaryColor,
              ),
              TextTitle(
                "Language".tr,
                textColor: AppColors.secondaryColor,
              ).padding(
                  padding:
                      const EdgeInsets.symmetric(horizontal: 15, vertical: 10)),
              Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Obx(() {
                    return LanguageSwitch(
                      onTap: () {
                        print("TTTTTTTTTTtt");
                        settingController.onChangedColor();
                        controllerLang.ChangeLang("ar");
                      },
                      title: "العربية",
                      backGroundColor: currentLanguageCode == 'ar'
                          ? AppColors.primeColor
                          : Colors.white,
                      ignoring: currentLanguageCode =='ar',
                      borderColor: currentLanguageCode == 'ar'
                          ? Colors.transparent
                          : Colors.black,
                      textColor:
                          currentLanguageCode == 'ar' ? Colors.white : Colors.black,
                      shadow: settingController.change.isTrue ? 0 : 0.07,
                    );
                  }),
                  Obx(() {
                    return LanguageSwitch(
                      onTap: () {
                        print("RRRRRRRRRRRrrr");
                        settingController.onChangedColor();
                        controllerLang.ChangeLang("en");
                      },
                      title: "English".tr,
                      backGroundColor: currentLanguageCode == 'en'
                          ? AppColors.primeColor
                          : Colors.white,
                      ignoring: currentLanguageCode=='en',
                      borderColor: currentLanguageCode == 'en'
                          ? Colors.transparent
                          : Colors.black,
                      textColor:
                          currentLanguageCode == 'en' ? Colors.white : Colors.black,
                      shadow: settingController.change.isTrue ? 0.07 : 0,
                    );
                  }),
                ],
              ),
              Divider(
                color: AppColors.secondaryColor,
              ),
              SizedBox(
                height: Get.height * 0.14,//142,
              ),
              HeadTitleText(
                'v $version',
                size: 20,
                color: AppColors.secondaryColor,
              ).center().padding(
                  padding:
                  const EdgeInsets.symmetric(horizontal: 15, vertical: 0)),
            ],
          ),
        ),
      ),
    );
  }

  Future<void> dialog() async {
    Get.defaultDialog(
        contentPadding: const EdgeInsets.only(bottom: 10),
        //  confirm: const Text('Yes'), cancel: const Text('Cancel'),
        title: 'Are you sure to logout?',
        middleText: '',
        actions: [
          Container(
            alignment: Alignment.center,
            decoration: BoxDecoration(
              color: Colors.white,
              border: Border.all(color: Colors.grey),
              borderRadius: BorderRadius.circular(10)
            ),
            width: 85,
            height: 35,
            child: InkWell(
              child: const RegularText('Yes' , textColor: Colors.black,),
              onTap: () async {
                await settingController.logout();
                RoutingManager.offAll(RoutesName.login);
              },
            ),
          ),
          const Padding(padding: EdgeInsets.symmetric(horizontal: 30)),
          Container(
            alignment: Alignment.center,
            width: 85,
            height: 35,
            decoration: BoxDecoration(
                color: AppColors.primeColor,
                borderRadius: BorderRadius.circular(10)),
            child: InkWell(
              child: const RegularText(
                'cancel',
                textColor: Colors.white,
              ),
              onTap: () {
                RoutingManager.back();
              },
            ),
          )
        ]);
  }
}
