import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../common/constant/colors.dart';
import '../../../../core/lang/app_language_controller.dart';
import '../../business_logic/setting_controller.dart';

class CustomTextLang extends StatelessWidget {
  CustomTextLang({Key? key}) : super(key: key);
  final SettingController settingController = Get.put(SettingController());

  @override
  Widget build(BuildContext context) {
    AppLanguageController controllerLang = Get.find();
    return Container(
      child: Row(
        children: [
          Center(
            child: MaterialButton(
              // color: AppColors.primeColor,
              color: settingController.change.isTrue
                  ? Colors.white
                  : AppColors.primeColor,
              textColor: Colors.white,
              onPressed: () {
                settingController.onChangedColor();

                controllerLang.ChangeLang("ar");
              },
              child: Text("العربية".tr),
            ),
          ),
          Center(
            child: MaterialButton(
              // color: AppColors.primeColor,
              color: settingController.change.isTrue
                  ? Colors.white
                  : AppColors.primeColor,
              textColor: Colors.white,
              onPressed: () {
                settingController.onChangedColor();

                controllerLang.ChangeLang("en");
              },
              child: Text("English".tr),
            ),
          ),
        ],
      ),
    );
  }
}
