import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';

class ProfileImage extends StatelessWidget {
  AuthController authController = Get.find<AuthController>();
  HomeController homeController = Get.find<HomeController>();

  ProfileImage({super.key});

  @override
  Widget build(BuildContext context) {
    return Obx(() {
      return SizedBox(
          width: Get.width,
          height: Get.height * 0.45,//350,
          child: authController.childrens[homeController.selectedChild.value]
                  .photo!.isNotEmpty
              ? Image.network(
                  authController
                      .childrens[homeController.selectedChild.value].photo!,
                  fit: BoxFit.cover)
              : authController.childrens[homeController.selectedChild.value]
                          .gender ==
                      'male'
                  ? Image.asset('asset/images/Profile-Boy.png')
                  : Image.asset('asset/images/Profile-Girl.png'));
    });
  }
}
