import '../../../../../../common/constant/colors.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';

class CenterTitleWidget extends StatelessWidget {
  final IconData iconData;
  final String title;
  const CenterTitleWidget({super.key, required this.title, required this.iconData});
  @override
  Widget build(BuildContext context) {
    return Center(
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        mainAxisAlignment: MainAxisAlignment.center,
        children: [
          Icon(iconData, color: AppColors.primeColor),
          const SizedBox(
            height: 5,
          ),
          Text(
            title,
            style: TextStyle(color: AppColors.primeColor),
          ),
          const SizedBox(
            height: 20,
          ),
          SizedBox(
            height: 38,
            width: 64,
            child: ClipRRect(
              borderRadius: BorderRadius.circular(15),
              child: ElevatedButton(
                style: ElevatedButton.styleFrom(
                  backgroundColor: AppColors.secondaryColor,
                  // Background color
                ),
                onPressed: () {
                  Navigator.of(context).pop();
                },
                child: Text(
                  'back'.tr,
                  style: TextStyle(
                    color: AppColors.primeColor,
                    fontWeight: FontWeight.bold,
                  ),
                ),
              ),
            ),
          ),
        ],
      ),
    );
  }
}
