import 'package:get/get.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../common/constant/apis.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../features/wallet/data/model/balanceDetailModel.dart';
import '../../../../../../features/wallet/data/model/financeOrderModel.dart';

import '../../../core/network/http.dart';
import '../data/service/wallet_service.dart';

class WalletController extends GetxController{

  RxFuture<List<FinanceModel>> financeToPayState = RxFuture([]);
  RxFuture<List<FinanceModel>> financeDoneState = RxFuture([]);
  RxFuture<BalanceDetailModel> balnaceDetailState = RxFuture(BalanceDetailModel.zero());

  WalletService walletService = WalletService();

  RxFuture<void> sendAcceptState = RxFuture(null);

  Future<void> getDigitalWalletBalanceDetail() async{
    await balnaceDetailState.observe(
        (_) async {
          return walletService.getDigitalWalletBalance();
        },
      onError: (e){
        snackBarWidget("Ooop's somthing wrong", "This User Does not Have Digital Wallet");
      }
    );
  }

  Future<void> getFinanceToPayInfo() async{
    await financeToPayState.observe(
            (_) async{
          return walletService.getFinanceOrderInfo('none');
        },
        onError: (p0){
          snackBarWidget("Ooop's somthing wrong", p0.toString());
        }
    );
  }

  Future<void> getFinanceDoneInfo() async{
    await financeDoneState.observe(
            (_) async{
          return walletService.getFinanceOrderInfo('done');
        },
        onError: (p0){
          snackBarWidget("Ooop's somthing wrong", p0.toString());
        }
    );
  }

  Future<void> sendFinanceAccept(String idFinance) async {
    await sendAcceptState.observe(
            (_) async {
              await walletService.sendAccept(idFinance);
              },
        onSuccess: (value){
          snackBarWidget("Success ", "You have paid the order");
        },
        onError: (e){
              snackBarWidget("Oooop's Error", e.toString());
            }
            );
  }

}