class FinanceModel {
  FinanceModel(
      {required this.id,
      required this.date,
      required this.student,
      required this.amount,
      required this.status,
      required this.desc});

  String id;
  String date;
  String student;
  String amount;
  String status;
  String desc;

  factory FinanceModel.zero() => FinanceModel(
      id: '', date: '', student: '', amount: '', status: '', desc: '');

  factory FinanceModel.fromJson(Map<String, dynamic> json) => FinanceModel(
      id: json["id"].toString(),
      date: json["date"],
      student: json["student"],
      amount: json["amount"].toString(),
      status: json["status"],
      desc: json["desc"]);

  static List<FinanceModel> fromJsonList(
      Map<String, dynamic> json, String key) {
    List<FinanceModel> financeOrders = [];
    try {
      if (json[key] == null) {
        return [];
      }
      json[key].forEach((fO) => financeOrders.add(
            FinanceModel.fromJson(fO),
          ));
    } catch (e) {
      print(
          'Error from Variable Model Error from Variable Model Error from Variable Model');
      print(e);
    }
    return financeOrders;
  }
}
