import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../features/wallet/data/model/balanceDetailModel.dart';
import '../../../../../../features/wallet/data/model/financeOrderModel.dart';
import '../../../../../../common/constant/apis.dart';
import '../../../../../../core/network/http.dart';

class WalletService {

  Future<BalanceDetailModel> getDigitalWalletBalance() async{
    Request request = Request(
      EndPoints.getDigitalWalletBalance,
      RequestMethod.get,
      authorized: true,
    );
    Map<String, dynamic> response = await request.sendRequest();
    return BalanceDetailModel.fromJson(response['data']);
  }

  Future<List<FinanceModel>> getFinanceOrderInfo(String status) async{
    Request request = Request(
        EndPoints.getFinanceOrder,
        RequestMethod.get,
        authorized: true,
        queryParams: {
          "status": status
        }
    );
    Map<String, dynamic> response = await request.sendRequest();
    return FinanceModel.fromJsonList(response,'data');
  }

  Future<void> sendAccept(String id) async {

    Request request = Request(
        EndPoints.sendAccept,
        RequestMethod.post,
        body: {
          "id": id
        },
        authorized: true
    );
    Map<String, dynamic> response = await request.sendRequest();
  }

  Future<void> getDailyLimit(int dailyLimit) async{
    Request request = Request(
        EndPoints.getFinanceOrder,
        RequestMethod.get,
        authorized: true,
        queryParams: {
          "daily_limit": dailyLimit
        }
    );

  }

}