import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/wallet/business_logic/wallet_controller.dart';
import '../../../../../../features/wallet/presentation/screen/financialOrder_wallet.dart';
import '../../../../../../features/wallet/presentation/screen/paid_wallet.dart';

class HomeWallet extends StatefulWidget {
  const HomeWallet({super.key});
  @override
  State<HomeWallet> createState() => _HomeWalletState();
}

class _HomeWalletState extends State<HomeWallet> {
  WalletController walletController = Get.find<WalletController>();
  loadData() async{
    await walletController.getDigitalWalletBalanceDetail();
  }
  @override
  void dispose() {
    super.dispose();
    loadData();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1),
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        body: Obx((){
          return walletController.balnaceDetailState.loading
            ? Center(
              child: CircularProgressIndicator(
              backgroundColor: AppColors.quizItem,
              color: AppColors.newPrimeColor,
                        ),
            )
            : Column(
            children: [
              Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  HeadTitleText(
                    size: 20,
                    'Balance :'.tr.toUpperCase(),
                    color: AppColors.newPrimeColor,
                  ).center().padding(
                      padding: const EdgeInsets.only(right: 10)),
                  NormalText(
                    walletController.balnaceDetailState.result.balance,
                    fontFamily: 'alatsi',
                    textColor:
                    Colors.black,
                    size: 20,
                  ).center(),
                ],
              ),
              const Expanded(
                child: DefaultTabController(
                  initialIndex: 1,
                  length: 2,
                  child: TabBarView(
                    children: [
                      WalletTabBar(),
                    ],
                  ),
                ),
              ),
            ],
          );
        })

      ),
    );
  }
}



class WalletTabBar extends StatefulWidget {
  const WalletTabBar({super.key});
  @override
  State<WalletTabBar> createState() => _WalletTabBarState();
}

class _WalletTabBarState extends State<WalletTabBar> with TickerProviderStateMixin{
  late final TabController _tabController;
  @override
  void initState() {
    super.initState();
    _tabController = TabController(length: 2, vsync: this);
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Column(
      children: <Widget>[
        Padding(
          padding: EdgeInsets.symmetric(horizontal: MediaQuery.of(context).size.width * 0.05 ,vertical: MediaQuery.of(context).size.width * 0.02 ),
          child: Container(
            height: MediaQuery.of(context).size.height * 0.035,
            decoration: BoxDecoration(
                color: AppColors.newSecondaryColor,
                borderRadius: BorderRadius.circular(20)
            ),
            child: TabBar.secondary(
              labelColor: Colors.white,
              unselectedLabelColor: AppColors.newPrimeColor,
              indicator: BoxDecoration(
                  color: AppColors.newPrimeColor,
                  borderRadius: BorderRadius.circular(20)
              ),
              controller: _tabController,
              tabs: <Widget>[
                Tab(
                    child: HeadTitleText(
                      "financialOrder".tr,
                      fontFamily: 'alatsi',
                      size: 15,
                    )
                ),
                Tab(
                    child: HeadTitleText(
                      "Paid".tr,
                      fontFamily: 'alatsi',
                      size: 15,
                    )
                ),
              ],
            ),
          ),
        ),
        Expanded(
          child: TabBarView(
            controller: _tabController,
            children: <Widget>[
              const FinancialOrderWallet(),
              PaidWallet()
            ],
          ),
        )
      ],
    );
  }
}
