import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/home/common/constant.dart';
import '../../../../../../features/wallet/business_logic/wallet_controller.dart';
import '../../../../../../features/wallet/data/model/financeOrderModel.dart';
import '../../../../../../features/wallet/presentation/widget/donePay.dart';

class PaidWallet extends StatelessWidget {
  PaidWallet({super.key});

  WalletController walletController = Get.find<WalletController>();

  @override
  Widget build(BuildContext context) {
    return Container(
      // color: Colors.blue,
      width: Get.size.width,
      height: Get.size.height,
      child: Padding(
        padding: EdgeInsets.only(top: Get.height * .02),
        child: walletController.financeDoneState.result.isEmpty
            ? Padding(
                padding: EdgeInsets.symmetric(horizontal: Get.width * 0.1),
                child: Center(
                  child: HeadTitleText(
                    "NoPaidOrder".tr,
                    size: 40,
                    color: AppColors.newPrimeColor,
                    fontFamily: AppFonts.alatsi,
                  ),
                ),
              )
            : ListView.builder(
                itemCount: walletController.financeDoneState.result.length,
                itemBuilder: (context, index) {
                  FinanceModel financeDone =
                      walletController.financeDoneState.result[index];
                  return DonePaid(doneFinance: financeDone).paddingOnly(bottom: MediaQuery.sizeOf(context).width * 0.05);
                }),
      ),
    );
  }
}
