import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/extensions/widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/wallet/data/model/financeOrderModel.dart';

import '../../../../common/constant/font.dart';

class DonePaid extends StatefulWidget {

  final FinanceModel doneFinance;

  const DonePaid({super.key, required this.doneFinance});

  @override
  State<DonePaid> createState() => _DonePaidState();
}

class _DonePaidState extends State<DonePaid> {
  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: Get.width * .05),
      child: Container(
        height: Get.height * .17,
        decoration: BoxDecoration(
            color: Colors.red.withOpacity(0.3),
            borderRadius: BorderRadius.circular(15)
        ),
        child: Container(
          height: Get.height * .17,
          width: Get.width,
          decoration: BoxDecoration(
              color: AppColors.newPrimeColor.withOpacity(0.3),
              borderRadius: BorderRadius.circular(20)
          ),
          child: Padding(
            padding: const EdgeInsets.all(8.0),
            child: Column(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Align(
                    alignment: Alignment.topRight,
                    child: HeadTitleText(
                      widget.doneFinance.date.substring(0, 10),
                      size: 10,
                    )
                ),
                HeadTitleText(
                  widget.doneFinance.student,
                  size: 15,
                  fontFamily: AppFonts.alatsi,
                ),
                AutoSizeText(
                  widget.doneFinance.desc,
                  maxLines: 2,
                  maxFontSize: 15,
                  minFontSize: 10,
                  style: TextStyle(fontFamily: AppFonts.alatsi),
                ),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    HeadTitleText(
                      '${widget.doneFinance.amount} IQD',
                      size: 20,
                      fontFamily: AppFonts.alatsi,
                    ),
                  ],
                )
              ],
            ),
          ),
        )

      ),
    );
  }
}




/*
Padding(
          padding: const EdgeInsets.all(8.0),
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              HeadTitleText(
                widget.doneFinance.student,
                size: 15,
                fontFamily: AppFonts.alatsi,
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  HeadTitleText(
                    widget.doneFinance.amount,
                    size: 20,
                    fontFamily: AppFonts.alatsi,
                  ),
                  HeadTitleText(
                    widget.doneFinance.date.substring(0, 10),
                    size: 20,
                    fontFamily: AppFonts.alatsi,
                  ),
                ],
              ),
              HeadTitleText(
                widget.doneFinance.desc,
                size: 20,
                fontFamily: AppFonts.alatsi,
              ),
            ],
          ),
        ),
 */