import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:provider/provider.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/widgets/snack_bar_widget.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../features/home/common/changeIndexNotifier.dart';
import '../../../../../../features/wallet/business_logic/wallet_controller.dart';
import '../../../../../../features/wallet/data/model/financeOrderModel.dart';
import '../../../../common/constant/font.dart';
import '../../../../core/routing/routing_manager.dart';

class ToPayFinance extends StatefulWidget {
  final FinanceModel toPayFinance;
  const ToPayFinance({super.key, required this.toPayFinance});
  @override
  State<ToPayFinance> createState() => _ToPayFinanceState();
}

class _ToPayFinanceState extends State<ToPayFinance> {
  WalletController walletController = Get.find<WalletController>();
  @override
  Widget build(BuildContext context) {
    return Consumer<ChangeIndexNotifier>(
      builder: (context,indexNotifier,child){
        return Column(
          children: [
            Padding(
              padding: EdgeInsets.symmetric(horizontal: Get.width * .05),
              child: GestureDetector(
                onTap: () async {
                  if(int.parse(widget.toPayFinance.amount) < int.parse(walletController.balnaceDetailState.result.balance)) {
                    await walletController.walletService.sendAccept(widget.toPayFinance.id);
                    await walletController.getDigitalWalletBalanceDetail();
                    await walletController.getFinanceToPayInfo();
                    snackBarWidget("Success ", "You have paid the ${widget.toPayFinance.desc}");
                  } else {
                    RoutingManager.to(RoutesName.chargeScreen);
                  }
                },
                child: Container(
                  height: Get.height * .17,
                  width: Get.width,
                  decoration: BoxDecoration(
                    color: AppColors.newPrimeColor.withOpacity(0.3),
                    borderRadius: BorderRadius.circular(20)
                  ),
                  child: Padding(
                    padding: const EdgeInsets.all(8.0),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Align(
                          alignment: Alignment.topRight,
                          child: HeadTitleText(
                            widget.toPayFinance.date.substring(0, 10),
                            size: 10,
                          )
                        ),
                        HeadTitleText(
                          widget.toPayFinance.student,
                          size: 15,
                          fontFamily: AppFonts.alatsi,
                        ),
                        AutoSizeText(
                          widget.toPayFinance.desc,
                          maxLines: 2,
                          maxFontSize: 20,
                          minFontSize: 12,
                          style: TextStyle(fontFamily: AppFonts.alatsi),
                        ),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            HeadTitleText(
                              '${widget.toPayFinance.amount} IQD',
                              size: 20,
                              fontFamily: AppFonts.alatsi,
                            ),
                            Container(
                              decoration: BoxDecoration(
                                color: Colors.green,
                                borderRadius: BorderRadius.circular(10)
                              ),
                              child: Padding(
                                padding: EdgeInsets.symmetric(horizontal: Get.width * .03, vertical: Get.height * .001),
                                child: Row(
                                  children: [
                                    HeadTitleText(
                                      int.parse(widget.toPayFinance.amount) > int.parse(walletController.balnaceDetailState.result.balance) ? '${'Charge'.tr} ' : '${'Accept'.tr} ',
                                      size: 15,
                                      color: Colors.white,
                                      fontFamily: AppFonts.alatsi,
                                    ),
                                    Icon(
                                      CupertinoIcons.checkmark,
                                      color: Colors.white,
                                      size: 20,
                                    )
                                  ],
                                ),
                              ),
                            ),
                          ],
                        )
                      ],
                    ),
                  ),
                ),
              ),
            )
          ],
        );
      }
    );
  }
}
