import 'dart:collection';

import 'package:get/get.dart';
import 'package:get/get_state_manager/src/simple/get_controllers.dart';
import 'package:rx_future/rx_future.dart';
import '../../../../../../features/calender/data/models/lesson.dart';
import '../../../../../../features/weekly_class/data/model/lesson_details_model.dart';
import '../../../../../../features/weekly_class/data/model/new_weekly_class.dart';
import '../../../../../../features/weekly_class/data/remote_source/new_weekly_class_service.dart';

class NewWeeklyClassController extends GetxController {
  NewWeeklyClassService newWeeklyService = NewWeeklyClassService();

  RxFuture<NewWeeklyClassModel> subjectTableState =
      RxFuture(NewWeeklyClassModel.zero());

  Map<String, newDaily> subjectMap = {};

  Future<void> getSubjectTable(String registrationRecordId,
      {String? date}) async {
    await subjectTableState.observe(
      (p0) async {
        return await newWeeklyService.getNewWeeklyClass(registrationRecordId);
      },
      onSuccess: (value) {
        subjectMap = value.subjectMap;
        print("✅ Loaded subject map days: ${subjectMap.keys}");
      },
    );
  }

  newDailySubject? getSubject(String day, int index) {
    final dayData = subjectMap[day.toLowerCase()];
    if (dayData == null || index >= dayData.subjects.length) return null;
    return dayData.subjects[index];
  }


  RxFuture<List<LessonModel>> getLessonsState = RxFuture(<LessonModel>[]);

  Future<void> getLessons(
      String responsibilityId, String createdFrom, String createdTo) async {
    await getLessonsState.observe(
          (value) async {
        return await newWeeklyService.getLessons(
            responsibilityId, createdFrom, createdTo);
      },
      onSuccess: (value) {
        lessonDetailsState =
            RxFuture(LessonDetailsModel.zero());
        if (value.isNotEmpty) {
          getLessonDetails(value.first.id);
        }
      },
    );
  }

  RxFuture<LessonDetailsModel> lessonDetailsState =
  RxFuture(LessonDetailsModel.zero());

  Future<void> getLessonDetails(int id) async {
    print("detail state");
    print(lessonDetailsState.toString());
    await lessonDetailsState.observe((value) async {

      return await newWeeklyService.lessonDetails(id);
    });
  }

}