import '../../../../../../features/calender/data/models/attachment.dart';
import '../../../../../../features/calender/data/models/homework_model.dart';
import '../../../../../../features/calender/data/models/lesson.dart';

class LessonDetailsModel {
  int id;
  String title;
  String description;
  String notes;
  ResponsibilityModel responsibilityModel;
  List<HomeWorkModel> homeworks;
  List<AttachmentModel> attachments;
  LessonDetailsModel(
      {required this.id,
      required this.title,
      required this.description,
      required this.notes,
      required this.responsibilityModel,
      required this.homeworks,
      required this.attachments});

  factory LessonDetailsModel.fromJson(Map<String, dynamic> json) =>
      LessonDetailsModel(
        id: json["id"],
        title: json["title"],
        description: json["description"],
        notes: json["notes"],
        responsibilityModel:
            ResponsibilityModel.fromJson(json["responsibility"]),
        homeworks: HomeWorkModel.fromJsonList(json),
        attachments: AttachmentModel.fromJsonList(json),
      );
  factory LessonDetailsModel.zero() => LessonDetailsModel(
      id: 0,
      title: '',
      description: '',
      notes: '',
      responsibilityModel: ResponsibilityModel.zero(),
      homeworks: [],
      attachments: []);
}

class HomeworkForLesson {
  int id;
  String title;
  String description;
  String dueTo;
  int lessonId;
  String createdAt;
  String updatedAt;
  HomeworkForLesson({
    required this.id,
    required this.title,
    required this.description,
    required this.dueTo,
    required this.lessonId,
    required this.createdAt,
    required this.updatedAt,
  });

  factory HomeworkForLesson.fromJson(Map<String, dynamic> json) =>
      HomeworkForLesson(
          id: json["id"],
          title: json["title"],
          description: json["description"],
          dueTo: json["due_to"],
          lessonId: json["lesson_id"],
          createdAt: json["created_at"],
          updatedAt: json["updated_at"]);

  static List<HomeworkForLesson> fromJsonList(Map<String, dynamic> json) {
    List<HomeworkForLesson> homeWorks = [];
    json["homeworks"].forEach(
      (element) => homeWorks.add(
        HomeworkForLesson.fromJson(element),
      ),
    );
    return homeWorks;
  }


}
