class NewWeeklyClassModel {
  String status;
  Map<String, newDaily> subjectMap;

  NewWeeklyClassModel({required this.status, required this.subjectMap});

  factory NewWeeklyClassModel.fromJson(Map<String, dynamic> json) {
    final Map<String, newDaily> map = {};

    // json["data"] is a map like { "sunday": {...}, "monday": {...}, ... }
    json["data"].forEach((day, value) {
      map[day.toLowerCase()] = newDaily(
        date: value["date"],
        subjects: newDailySubject.fromJsonList(value["list"]),
      );
    });

    return NewWeeklyClassModel(status: json["status"], subjectMap: map);
  }

  factory NewWeeklyClassModel.zero() =>
      NewWeeklyClassModel(status: '', subjectMap: {});

  newDaily? getByDay(String day) => subjectMap[day.toLowerCase()];
}

class newDaily {
  String? date;
  List<newDailySubject> subjects;

  newDaily({required this.date, required this.subjects});

  factory newDaily.zero() => newDaily(date: '', subjects: []);
}

class newDailySubject {
  int? id;
  int? order;
  String? day;
  String? date;
  String? subject;
  String? eduClass;
  String? teacher;
  String? grade;

  newDailySubject({
    required this.id,
    required this.order,
    required this.day,
    required this.date,
    required this.subject,
    required this.eduClass,
    required this.teacher,
    required this.grade,
  });

  factory newDailySubject.fromJson(Map<String, dynamic> json) => newDailySubject(
        id: json["id"],
        order: json["order"],
        day: json["day"],
        date: json["date"],
        subject: json["subject"],
        eduClass: json["edu_class"],
        teacher: json["teacher"],
        grade: json["grade"],
      );

  factory newDailySubject.zero() => newDailySubject(
        id: 0,
        order: 0,
        day: '',
        date: '',
        subject: '',
        eduClass: '',
        teacher: '',
        grade: '',
      );

  static List<newDailySubject> fromJsonList(List<dynamic> data) {
    return data.map((e) => newDailySubject.fromJson(e)).toList();
  }
}
