import 'dart:convert';

import '../../../../../../features/calender/data/models/grade_type_model.dart';
import '../../../../../../features/calender/data/models/lesson.dart';
import '../../../../../../features/calender/data/models/subject_model.dart';

class WeeklyClassModel {
  String status;
  List<Daily> subjects;

  WeeklyClassModel({required this.status, required this.subjects});

  factory WeeklyClassModel.fromJson(Map<String, dynamic> json) {
    List<Daily> subjects = [];
    List;
    json["data"].forEach((key, value) {
      subjects.add(Daily(day: key, subjects: DailySubject.fromJsonList(value)));
    });
    return WeeklyClassModel(status: json["status"], subjects: subjects);
  }

  factory WeeklyClassModel.zero() => WeeklyClassModel(status: '', subjects: []);
  List<DailySubject> getDailyClass(String day) {
    Daily dailySubject = subjects.firstWhere((element) => element.day == day);
    return dailySubject.subjects;
  }

}

class Daily {
  String day;

  List<DailySubject> subjects;

  Daily({required this.day, required this.subjects});

  factory Daily.zero() => Daily(day: '', subjects: []);
}


class DailySubject {
  int id;
  int order;
  String day;
  TeacherModel teacherModel;
  SubjectModel subjectModel;
  EducationClass educationClass;
  GradeType gradeType;

  DailySubject(
      {required this.id,
      required this.order,
      required this.day,
      required this.teacherModel,
      required this.subjectModel,
      required this.educationClass,
      required this.gradeType});

  factory DailySubject.fromJson(Map<String, dynamic> json) => DailySubject(
      id: json["id"],
      order: json["order"],
      day: json["day"],
      teacherModel: TeacherModel.fromJson(json["teacher"]),
      subjectModel: SubjectModel.fromJson(json["subject"]),
      educationClass: EducationClass.fromJson(json["edu_class"]),
      gradeType: GradeType.fromJson(json["grade"]));


  static List<DailySubject> fromJsonList(List<dynamic> json) {
    List<DailySubject> subjects = [];
    for (var element in json) {
      subjects.add(DailySubject.fromJson(element));
    }
    return subjects;
  }
}
