import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/widgets.dart';
import 'package:get/get.dart';
import '../../../../../../common/constant/colors.dart';
import '../../../../../../common/constant/font.dart';
import '../../../../../../common/widgets/circular_progress_indicator.dart';
import '../../../../../../common/widgets/text.dart';
import '../../../../../../core/routing/routing_manager.dart';
import '../../../../../../features/auth/business_logic/auth_controller.dart';
import '../../../../../../features/home/business_logic/home_controller.dart';
import '../../../../../../features/home/common/myExtension.dart';
import '../../../../../../features/weekly_class/business_logic/new_weekly_class_controller.dart';
import '../../../../../../features/weekly_class/business_logic/weekly_class_controller.dart';
import '../../../../../../features/weekly_class/data/model/new_weekly_class.dart';
import '../../../../../../helpers/date_helpers.dart';


class WeeklyClassScreen extends StatefulWidget {

  const WeeklyClassScreen({super.key});

  @override
  State<WeeklyClassScreen> createState() => _WeeklyClassScreenState();
}

class _WeeklyClassScreenState extends State<WeeklyClassScreen> {
  
  final WeeklyClassController weeklyClassController =
      Get.find<WeeklyClassController>();

  NewWeeklyClassController newWeeklyController =
  Get.find<NewWeeklyClassController>();

  AuthController authController = Get.find<AuthController>();

  HomeController homeController = Get.find<HomeController>();

  Map<String,newDaily>? subjectMap;


  var sunday;
  var monday;
  var tuesday;
  var wednesday;
  var thursday;

  @override
  void initState() {
    super.initState();
    newWeeklyController.getSubjectTable(authController.childrens[homeController.selectedChild.value].id);
    subjectMap = newWeeklyController.subjectMap;
  }
  @override
  Widget build(BuildContext context) {


    return Container(
      decoration: const BoxDecoration(
          color: Color.fromRGBO(238, 238, 238, 1), //Colors.grey,
          image: DecorationImage(
              image: AssetImage('asset/images/backGroundLogIn1.png'),
              fit: BoxFit.cover)),
      child: Scaffold(
        backgroundColor: Colors.transparent,
        appBar: AppBar(
          backgroundColor: Colors.transparent,
          scrolledUnderElevation: 0,
          leading: IconButton(
            icon: const Icon(Icons.arrow_back),
            color: AppColors.newPrimeColor,
            onPressed: () {
              Navigator.pop(context);
            },
          ),
          title: HeadTitleText(
            'Weekly Schedule'.tr,
            color: AppColors.newPrimeColor,
            fontFamily: 'alatsi',
          ).padding(padding: EdgeInsets.symmetric(horizontal: Get.width * .2)),
        ),
        body: Obx(() {
          return newWeeklyController.subjectTableState.loading
              ? const CircularProgressIndicatorWidget()
              :
          SingleChildScrollView(
            child: Column(
              children: [
                Padding(
                  padding: const EdgeInsets.only(
                      left: 20.0, right: 20.0, top: 15),
                  child: Container(
                    width: Get.width * 0.88,//361,
                    height: Get.height * 0.29,//250,
                    decoration: BoxDecoration(
                      gradient: const LinearGradient(
                          begin: Alignment.centerRight,
                          end: Alignment.topRight,
                          colors: [
                            Color.fromRGBO(232, 211, 211, 1),
                            Color.fromRGBO(217, 217, 217, 1)
                          ]),
                      borderRadius: BorderRadius.circular(13.0),
                    ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            HeadTitleText(
                              "Sunday".tr,
                              fontFamily: 'alatsi',
                              color: AppColors.newPrimeColor,
                              size: 20,
                            ),
                            HeadTitleText(
                              newWeeklyController.subjectMap['sunday']!.date.toString() ?? '',//sunday!.date.toString(),//sunday!.date.toString() ,//sunday[0]['date'],
                              fontFamily: AppFonts.alatsi,
                              color: Colors.black,
                              size: 18,
                            )
                          ],
                        ).padding(
                            padding: const EdgeInsets.only(
                                left: 23.0, right: 23.0, top: 15.0, bottom: 25)),
                        Container(
                          height: Get.height * .18,//120,
                          child: newWeeklyController.subjectMap['sunday']!.subjects.isEmpty//sunday.subjects == null
                              ? Center(
                            child: HeadTitleText(
                              "No Lesson'\s For This Day",
                              color: AppColors.newPrimeColor,
                              size: 20,
                              fontFamily: AppFonts.alatsi,
                            ),
                          ) : ListView.builder(
                              scrollDirection: Axis.horizontal,
                              itemCount: newWeeklyController.subjectMap['sunday']!.subjects.length,//sunday.subjects.length,//sunday.length, //daySchedule.length,
                              itemBuilder: (context, index) {
                                return Column(
                                  crossAxisAlignment:
                                  CrossAxisAlignment.start,
                                  children: [
                                    const Icon(
                                      CupertinoIcons.book,
                                      size: 30,
                                    ),
                                    SizedBox(
                                      width: Get.width * .1 ,//50,
                                      height: Get.height * .035,//25,
                                      child: HeadTitleText(
                                        newWeeklyController.subjectMap['sunday']!.subjects[index].order.toString(),//sunday.subjects[index].order.toString(),
                                        fontFamily: AppFonts.alatsi,
                                        size: 15,
                                      ).padding(padding: EdgeInsets.only(left: Get.width * .025, right: Get.width * .025, top: Get.height * .007)),
                                    ),
                                    SizedBox(
                                      width: Get.width * .17 ,//70,
                                      height: Get.height * .065,//50,
                                      child: Center(
                                        child: AutoSizeText(
                                          newWeeklyController.subjectMap['sunday']!.subjects[index].subject.toString() ?? '',
                                          style: TextStyle(
                                              color: AppColors.newPrimeColor,
                                              // fontSize: 20,
                                              fontFamily: AppFonts.alatsi,
                                          ),
                                          maxLines: 1,
                                          maxFontSize: 20,
                                          minFontSize: 10,
                                        ),
                                      ),
                                    ),
                                    SizedBox(
                                      width: Get.width * .17 ,//70,
                                      height: Get.height * .029,//25,
                                      child:
                                      Center(
                                        child: AutoSizeText(
                                          newWeeklyController.subjectMap['sunday']!.subjects[index].teacher.toString() ?? '',
                                          style: TextStyle(
                                              fontFamily: AppFonts.alatsi,
                                              fontWeight: FontWeight.normal
                                          ),
                                          maxLines: 2,
                                          maxFontSize: 20,
                                          minFontSize: 10,
                                        ),
                                      ),
                                    ),
                                  ],
                                ).onTap(() async {
                                  await newWeeklyController.getLessons(
                                      newWeeklyController.subjectMap['sunday']!.subjects[index].id.toString(),//subjects[index].id,
                                      DateHerlpers.getWeekDates(DateTime.now())[0].toString().substring(0, 10),
                                      DateHerlpers.getWeekDates(DateTime.now())[0].toString().substring(0, 10));
                                  RoutingManager.to(RoutesName.classPage, arguments: newWeeklyController.subjectMap['sunday']!.subjects[index].subject);
                                }).padding(
                                    padding: EdgeInsets.symmetric(
                                        horizontal: Get.width * .02));
                              }
                          ),
                        )
                      ],
                    ),
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.only(
                      left: 23.0, right: 23.0, top: 15),
                  child: Container(
                    width: Get.width * 0.9,//361,
                    height: Get.height * 0.29,//250,
                    decoration: BoxDecoration(
                      gradient: const LinearGradient(
                          begin: Alignment.centerRight,
                          end: Alignment.topRight,
                          colors: [
                            Color.fromRGBO(232, 211, 211, 1),
                            Color.fromRGBO(217, 217, 217, 1)
                          ]),
                      borderRadius: BorderRadius.circular(13.0),
                    ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            HeadTitleText(
                              "Monday".tr,//newWeeklyController.subjects[0].day.toString().toUpperCase(),//sunday[0]['day'].toUpperCase(),
                              fontFamily: 'alatsi',
                              color: AppColors.newPrimeColor,
                              size: 20,
                            ), //.padding(padding: const EdgeInsets.only(top: 8)),
                            HeadTitleText(
                              newWeeklyController.subjectMap['monday']!.date.toString() ?? '',//monday!.date.toString(),//sunday!.date.toString() ,//sunday[0]['date'],
                              fontFamily: AppFonts.alatsi,
                              color: Colors.black,
                              size: 18,
                            )
                          ],
                        ).padding(
                            padding: const EdgeInsets.only(
                                left: 23.0, right: 23.0, top: 15.0, bottom: 25)),
                        SizedBox(
                          height: Get.height * .18,
                          child: newWeeklyController.subjectMap['monday']!.subjects.isEmpty//monday.subjects.isNull
                              ? Center(
                            child: HeadTitleText(
                              "No Lesson's For This Day",
                              color: AppColors.newPrimeColor,
                              size: 20,
                              fontFamily: AppFonts.alatsi,
                            ),
                          ) : Center(
                            child: ListView.builder(
                                scrollDirection: Axis.horizontal,
                                itemCount: newWeeklyController.subjectMap['monday']!.subjects.length,//monday.subjects.length,//sunday.length, //daySchedule.length,
                                itemBuilder: (context, index) {
                                  return Column(
                                    mainAxisAlignment: MainAxisAlignment.center,
                                    crossAxisAlignment:
                                    CrossAxisAlignment.start,
                                    children: [
                                      const Icon(
                                        CupertinoIcons.book,
                                        size: 30,
                                      ),
                                      SizedBox(
                                        width: Get.width * .1 ,//50,
                                        height: Get.height * .035,//25,
                                        child: HeadTitleText(
                                          newWeeklyController.subjectMap['monday']!.subjects[index].order.toString() ?? '',//monday.subjects[index].order.toString(),
                                          fontFamily: AppFonts.alatsi,
                                          size: 15,
                                        ).padding(padding: EdgeInsets.only(left: Get.width * .025, right: Get.width * .025, top: Get.height * .007)),
                                      ),
                                      SizedBox(
                                        width: Get.width * .17 ,//70,
                                        height: Get.height * .065,//50,
                                        child: Center(
                                          child: HeadTitleText(
                                            newWeeklyController.subjectMap['monday']!.subjects[index].subject.toString() ?? '',//monday.subjects[index].subject.toString(),
                                            fontFamily: AppFonts.alatsi,
                                            size: 10,
                                            color: AppColors.newPrimeColor,
                                          ),
                                        ),
                                      ),
                                      SizedBox(
                                        width: Get.width * .17 ,//70,
                                        height: Get.height * .029,//25,
                                        child: Center(
                                          child: AutoSizeText(
                                            newWeeklyController.subjectMap['monday']!.subjects[index].teacher.toString() ?? '',
                                            style: TextStyle(
                                                // fontSize: 20,
                                                fontFamily: AppFonts.alatsi,
                                                fontWeight: FontWeight.normal
                                            ),
                                            maxLines: 2,
                                            maxFontSize: 20,
                                            minFontSize: 10,
                                          ),
                                        ),
                                        // HeadTitleText(
                                        //   newWeeklyController.subjectMap['monday']!.subjects[index].teacher.toString() ?? '',//monday.subjects[index].teacher.toString(),
                                        //   fontFamily: AppFonts.alatsi,
                                        //   size: 15,
                                        // ),
                                      ),
                                    ],
                                  ).onTap(() async {
                                    await newWeeklyController.getLessons(
                                        newWeeklyController.subjectMap['monday']!.subjects[index].id.toString(),//subjects[index].id,
                                        DateHerlpers.getWeekDates(DateTime.now())[1].toString().substring(0, 10),
                                        DateHerlpers.getWeekDates(DateTime.now())[1].toString().substring(0, 10));
                                    RoutingManager.to(RoutesName.classPage, arguments: newWeeklyController.subjectMap['monday']!.subjects[index].subject);
                                  }).padding(
                                      padding: const EdgeInsets.symmetric(
                                          horizontal: 10));
                                }
                            ),
                          ),
                        )
                      ],
                    ),
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.only(
                      left: 23.0, right: 23.0, top: 15),
                  child: Container(
                    width: Get.width * 0.9,//361,
                    height: Get.height * 0.29,//250,
                    decoration: BoxDecoration(
                      gradient: const LinearGradient(
                          begin: Alignment.centerRight,
                          end: Alignment.topRight,
                          colors: [
                            Color.fromRGBO(232, 211, 211, 1),
                            Color.fromRGBO(217, 217, 217, 1)
                          ]),
                      borderRadius: BorderRadius.circular(13.0),
                    ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            HeadTitleText(
                              "Tuesday".tr,//newWeeklyController.subjects[0].day.toString().toUpperCase(),//sunday[0]['day'].toUpperCase(),
                              fontFamily: 'alatsi',
                              color: AppColors.newPrimeColor,
                              size: 20,
                            ), //.padding(padding: const EdgeInsets.only(top: 8)),
                            HeadTitleText(
                              newWeeklyController.subjectMap['tuesday']!.date.toString() ?? '',//tuesday!.date.toString(),//sunday!.date.toString() ,//sunday[0]['date'],
                              fontFamily: AppFonts.alatsi,
                              color: Colors.black,
                              size: 18,
                            )
                          ],
                        ).padding(
                            padding: const EdgeInsets.only(
                                left: 23.0, right: 23.0, top: 15.0, bottom: 25)),
                        SizedBox(
                          height: Get.height * .18,
                          child: newWeeklyController.subjectMap['tuesday']!.subjects.isEmpty
                              ? Center(
                            child: HeadTitleText(
                              "No Lesson'\s For This Day",
                              color: AppColors.newPrimeColor,
                              size: 20,
                              fontFamily: AppFonts.alatsi,
                            ),
                          ) : ListView.builder(
                              scrollDirection: Axis.horizontal,
                              itemCount: newWeeklyController.subjectMap['tuesday']!.subjects.length,//tuesday.subjects.length,//sunday.length, //daySchedule.length,
                              itemBuilder: (context, index) {
                                return Column(
                                  crossAxisAlignment:
                                  CrossAxisAlignment.start,
                                  children: [
                                    const Icon(
                                      CupertinoIcons.book,
                                      size: 30,
                                    ),
                                    SizedBox(
                                      width: Get.width * .1 ,//50,
                                      height: Get.height * .035,//25,
                                      child: HeadTitleText(
                                        newWeeklyController.subjectMap['tuesday']!.subjects[index].order.toString() ?? '',//tuesday.subjects[index].order.toString(),
                                        fontFamily: AppFonts.alatsi,
                                        size: 15,
                                      ).padding(padding: EdgeInsets.only(left: Get.width * .025, right: Get.width * .025, top: Get.height * .007)),
                                    ),
                                    SizedBox(
                                      width: Get.width * .17 ,//70,
                                      height: Get.height * .065,//50,
                                      child: Center(
                                        child: HeadTitleText(
                                          newWeeklyController.subjectMap['tuesday']!.subjects[index].subject.toString() ?? '',//tuesday.subjects[index].subject.toString(),
                                          fontFamily: AppFonts.alatsi,
                                          size: 10,
                                          color: AppColors.newPrimeColor,
                                        ),
                                      ),
                                    ),
                                    SizedBox(
                                      width: Get.width * .17 ,//70,
                                      height: Get.height * .029,//25,
                                      child: Center(
                                        child: AutoSizeText(
                                          newWeeklyController.subjectMap['tuesday']!.subjects[index].teacher.toString() ?? '',
                                          style: TextStyle(
                                              fontSize: 20,
                                              fontFamily: AppFonts.alatsi,
                                              fontWeight: FontWeight.normal
                                          ),
                                          maxLines: 2,
                                          maxFontSize: 20,
                                          minFontSize: 10,
                                        ),
                                      ),
                                    ),
                                  ],
                                ).onTap(() async {
                                  print(DateHerlpers.getWeekDates(DateTime.now()));
                                  try{
                                    await newWeeklyController.getLessons(
                                        newWeeklyController.subjectMap['tuesday']!.subjects[index].id.toString(),//subjects[index].id,
                                        DateHerlpers.getWeekDates(DateTime.now())[2].toString().substring(0, 10),
                                        DateHerlpers.getWeekDates(DateTime.now())[2].toString().substring(0, 10));
                                    RoutingManager.to(RoutesName.classPage, arguments: newWeeklyController.subjectMap['tuesday']!.subjects[index].subject);
                                  }catch(e){
                                    print(e);
                                  }
                                }).padding(
                                    padding: const EdgeInsets.symmetric(
                                        horizontal: 10));
                              }
                          ),
                        )
                      ],
                    ),
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.only(
                      left: 23.0, right: 23.0, top: 15),
                  child: Container(
                    width: Get.width * 0.9,//361,
                    height: Get.height * 0.29,//250,
                    decoration: BoxDecoration(
                      gradient: const LinearGradient(
                          begin: Alignment.centerRight,
                          end: Alignment.topRight,
                          colors: [
                            Color.fromRGBO(232, 211, 211, 1),
                            Color.fromRGBO(217, 217, 217, 1)
                          ]),
                      borderRadius: BorderRadius.circular(13.0),
                    ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            HeadTitleText(
                              "Wednesday".tr,//newWeeklyController.subjects[0].day.toString().toUpperCase(),//sunday[0]['day'].toUpperCase(),
                              fontFamily: 'alatsi',
                              color: AppColors.newPrimeColor,
                              size: 20,
                            ), //.padding(padding: const EdgeInsets.only(top: 8)),
                            HeadTitleText(
                              newWeeklyController.subjectMap['wednesday']!.date.toString() ?? '',//wednesday!.date.toString(),//sunday!.date.toString() ,//sunday[0]['date'],
                              fontFamily: AppFonts.alatsi,
                              color: Colors.black,
                              size: 18,
                            )
                          ],
                        ).padding(
                            padding: const EdgeInsets.only(
                                left: 23.0, right: 23.0, top: 15.0, bottom: 25)),
                        SizedBox(
                          height: Get.height * .18,
                          child: newWeeklyController.subjectMap['wednesday']!.subjects.isEmpty//wednesday.subjects == null
                              ? Center(
                            child: HeadTitleText(
                              "No Lesson'\s For This Day",
                              color: AppColors.newPrimeColor,
                              size: 20,
                              fontFamily: AppFonts.alatsi,
                            ),
                          )
                              : ListView.builder(
                              scrollDirection: Axis.horizontal,
                              itemCount: newWeeklyController.subjectMap['wednesday']!.subjects.length,//wednesday.subjects.length,//sunday.length, //daySchedule.length,
                              itemBuilder: (context, index) {
                                return Column(
                                  crossAxisAlignment:
                                  CrossAxisAlignment.start,
                                  children: [
                                    const Icon(
                                      CupertinoIcons.book,
                                      size: 30,
                                    ),
                                    SizedBox(
                                      width: Get.width * .1 ,//50,
                                      height: Get.height * .035,//25,
                                      child: HeadTitleText(
                                        newWeeklyController.subjectMap['wednesday']!.subjects[index].order.toString(),//wednesday.subjects[index].order.toString(),
                                        fontFamily: AppFonts.alatsi,
                                        size: 15,
                                      ).padding(padding: EdgeInsets.only(left: Get.width * .025, right: Get.width * .025, top: Get.height * .007)),
                                    ),
                                    SizedBox(
                                      width: Get.width * .17 ,//70,
                                      height: Get.height * .065,//50,
                                      child: Center(
                                        child: HeadTitleText(
                                          newWeeklyController.subjectMap['wednesday']!.subjects[index].subject.toString() ?? '',//wednesday.subjects[index].subject.toString(),
                                          fontFamily: AppFonts.alatsi,
                                          size: 10,
                                          color: AppColors.newPrimeColor,
                                        ),
                                      ),
                                    ),
                                    SizedBox(
                                      width: Get.width * .1 ,//50,
                                      height: Get.height * .03,//25,
                                      child: Center(
                                        child: AutoSizeText(
                                          newWeeklyController.subjectMap['wednesday']!.subjects[index].teacher.toString() ?? '',
                                          style: TextStyle(
                                              fontSize: 20,
                                              fontFamily: AppFonts.alatsi,
                                              fontWeight: FontWeight.normal
                                          ),
                                          maxLines: 2,
                                          maxFontSize: 20,
                                          minFontSize: 10,
                                        ),
                                      ),
                                      // HeadTitleText(
                                      //   newWeeklyController.subjectMap['wednesday']!.subjects[index].teacher.toString() ?? '',//wednesday.subjects[index].teacher.toString(),
                                      //   fontFamily: AppFonts.alatsi,
                                      //   size: 15,
                                      // ),
                                    ),
                                  ],
                                ).onTap(() async {
                                  await newWeeklyController.getLessons(
                                      newWeeklyController.subjectMap['wednesday']!.subjects[index].id.toString(),//subjects[index].id,
                                      DateHerlpers.getWeekDates(DateTime.now())[3].toString().substring(0, 10),
                                      DateHerlpers.getWeekDates(DateTime.now())[3].toString().substring(0, 10));
                                  RoutingManager.to(RoutesName.classPage, arguments: newWeeklyController.subjectMap['wednesday']!.subjects[index].subject);
                                }).padding(
                                    padding: const EdgeInsets.symmetric(
                                        horizontal: 10));
                              }
                          ),
                        )
                      ],
                    ),
                  ),
                ),
                Padding(
                  padding: const EdgeInsets.only(
                      left: 23.0, right: 23.0, top: 15),
                  child: Container(
                    width: Get.width * 0.9,//361,
                    height: Get.height * 0.29,//250,
                    decoration: BoxDecoration(
                      gradient: const LinearGradient(
                          begin: Alignment.centerRight,
                          end: Alignment.topRight,
                          colors: [
                            Color.fromRGBO(232, 211, 211, 1),
                            Color.fromRGBO(217, 217, 217, 1)
                          ]),
                      borderRadius: BorderRadius.circular(13.0),
                    ),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            HeadTitleText(
                              "Thursday".tr,//newWeeklyController.subjects[0].day.toString().toUpperCase(),//sunday[0]['day'].toUpperCase(),
                              fontFamily: 'alatsi',
                              color: AppColors.newPrimeColor,
                              size: 20,
                            ), //.padding(padding: const EdgeInsets.only(top: 8)),
                            HeadTitleText(
                              newWeeklyController.subjectMap['thursday']!.date.toString() ?? '',//thursday!.date.toString(),//sunday!.date.toString() ,//sunday[0]['date'],
                              fontFamily: AppFonts.alatsi,
                              color: Colors.black,
                              size: 18,
                            )
                          ],
                        ).padding(
                            padding: const EdgeInsets.only(
                                left: 23.0, right: 23.0, top: 15.0, bottom: 25)),
                        SizedBox(
                          height: Get.height * .18,
                          child: newWeeklyController.subjectMap['thursday']!.subjects.isEmpty//thursday.subjects.isEmpty
                              ? Center(
                            child: HeadTitleText(
                              "No Lesson's For This Day",
                              color: AppColors.newPrimeColor,
                              size: 20,
                              fontFamily: AppFonts.alatsi,
                            ),
                          ) : ListView.builder(
                              scrollDirection: Axis.horizontal,
                              itemCount: newWeeklyController.subjectMap['thursday']!.subjects.length,//thursday.subjects.length,//sunday.length, //daySchedule.length,
                              itemBuilder: (context, index) {
                                return Column(
                                  crossAxisAlignment:
                                  CrossAxisAlignment.start,
                                  children: [
                                    const Icon(
                                      CupertinoIcons.book,
                                      size: 30,
                                    ),
                                    SizedBox(
                                      width: Get.width * .1 ,//50,
                                      height: Get.height * .035,//25,
                                      child: HeadTitleText(
                                        newWeeklyController.subjectMap['thursday']!.subjects[index].order.toString() ?? '',//thursday.subjects[index].order.toString(),
                                        fontFamily: AppFonts.alatsi,
                                        size: 15,
                                      ).padding(padding: EdgeInsets.only(left: Get.width * .025, right: Get.width * .025, top: Get.height * .007)),
                                    ),
                                    SizedBox(
                                      width: Get.width * .17 ,//70,
                                      height: Get.height * .065,//50,
                                      child: Center(
                                        child: HeadTitleText(
                                          newWeeklyController.subjectMap['thursday']!.subjects[index].subject.toString() ?? '',//thursday.subjects[index].subject.toString(),
                                          fontFamily: AppFonts.alatsi,
                                          size: 10,
                                          color: AppColors.newPrimeColor,
                                        ),
                                      ),
                                    ),
                                    SizedBox(
                                      width: Get.width * .17 ,//70,
                                      height: Get.height * .029,//25,
                                      child: Center(
                                        child: AutoSizeText(
                                          newWeeklyController.subjectMap['thursday']!.subjects[index].teacher.toString() ?? '',
                                          style: TextStyle(
                                              // fontSize: 20,
                                              fontFamily: AppFonts.alatsi,
                                              fontWeight: FontWeight.normal
                                          ),
                                          maxLines: 2,
                                          maxFontSize: 20,
                                          minFontSize: 10,
                                        ),
                                      ),
                                    ),
                                  ],
                                ).onTap(() async {
                                  await newWeeklyController.getLessons(
                                      newWeeklyController.subjectMap['thursday']!.subjects[index].id.toString(),//subjects[index].id,
                                      DateHerlpers.getWeekDates(DateTime.now())[4].toString().substring(0, 10),
                                      DateHerlpers.getWeekDates(DateTime.now())[4].toString().substring(0, 10));
                                  RoutingManager.to(RoutesName.classPage, arguments: newWeeklyController.subjectMap['thursday']!.subjects[index].subject);
                                }).padding(
                                    padding: const EdgeInsets.symmetric(
                                    horizontal: 10)
                                );
                              }
                          ),
                        )
                      ],
                    ),
                  ),
                ),
                SizedBox(height: Get.height * 0.05,)

              ],
            ),
          );
        }),
      ),
    );
  }
}





//   old version code ;;;;;
// return Scaffold(
// appBar: AppBarWidget(
// title: DateTime.now().toDay().toLowerCase().toString().tr,
// // child: IconButton(
// //   color: Colors.white,
// //   icon: const Icon(Icons.calendar_month),
// //   onPressed: () {},
// // ),
// ),
// body: Obx(() {
// return weeklyClassController.subjectTableState.loading
// ? const CircularProgressIndicatorWidget()
//     : SizedBox(
// width: Get.width,
// height: Get.height,
// child: ListView.builder(
// itemCount: weeklyClassController
//     .subjectTableState.result.subjects.length,
// itemBuilder: (BuildContext context, index) {
// return DayClassWidget(
// date: DateHerlpers.getWeekDates(DateTime.now())[index],
// subjects: weeklyClassController
//     .subjectTableState.result.subjects[index].subjects,
// daily: weeklyClassController
//     .subjectTableState.result.subjects[index],
// );
// },
// ),
// );
// }),
// );